/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.datapack.slabfish;

import com.teamabnormals.environmental.common.entity.animal.slabfish.SlabfishOverlay;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.Tags;

public class EnvironmentalSlabfishOverlays {
    public static final ResourceKey<SlabfishOverlay> MUD = EnvironmentalSlabfishOverlays.create("mud");
    public static final ResourceKey<SlabfishOverlay> SNOW = EnvironmentalSlabfishOverlays.create("snow");
    public static final ResourceKey<SlabfishOverlay> EGG = EnvironmentalSlabfishOverlays.create("egg");

    public static void bootstrap(BootstrapContext<SlabfishOverlay> context) {
        EnvironmentalSlabfishOverlays.register(context, MUD, true, (Item)EnvironmentalItems.MUD_BALL.get());
        EnvironmentalSlabfishOverlays.register(context, SNOW, true, Items.SNOWBALL);
        EnvironmentalSlabfishOverlays.register(context, EGG, false, (TagKey<Item>)Tags.Items.EGGS);
    }

    public static Holder.Reference<SlabfishOverlay> register(BootstrapContext<SlabfishOverlay> context, ResourceKey<SlabfishOverlay> key, boolean backpack, Optional<Holder<Item>> itemHolder, Optional<TagKey<Item>> itemTagKey) {
        return context.register(key, (Object)new SlabfishOverlay(ResourceLocation.fromNamespaceAndPath((String)key.location().getNamespace(), (String)("overlay/" + key.location().getPath())), !backpack ? Optional.empty() : Optional.of(ResourceLocation.fromNamespaceAndPath((String)key.location().getNamespace(), (String)("overlay/" + key.location().getPath() + "_backpack"))), itemHolder, itemTagKey));
    }

    public static Holder.Reference<SlabfishOverlay> register(BootstrapContext<SlabfishOverlay> context, ResourceKey<SlabfishOverlay> key, boolean backpack, Item item) {
        return EnvironmentalSlabfishOverlays.register(context, key, backpack, Optional.of(BuiltInRegistries.ITEM.wrapAsHolder((Object)item)), Optional.empty());
    }

    public static Holder.Reference<SlabfishOverlay> register(BootstrapContext<SlabfishOverlay> context, ResourceKey<SlabfishOverlay> key, boolean backpack, TagKey<Item> tag) {
        return EnvironmentalSlabfishOverlays.register(context, key, backpack, Optional.empty(), Optional.of(tag));
    }

    public static ResourceKey<SlabfishOverlay> create(String name) {
        return ResourceKey.create(EnvironmentalRegistries.SLABFISH_OVERLAY, (ResourceLocation)Environmental.location(name));
    }
}

