/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.datapack.slabfish;

import com.teamabnormals.environmental.common.slabfish.SlabfishBackpack;
import com.teamabnormals.environmental.common.slabfish.SlabfishVariant;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishAndCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishBreedCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishDimensionCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishEventCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishHeightCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishImpossibleCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishInBiomeCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishInBiomeKeyCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishInFluidCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishInsomniaCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishLightCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishModLoadedCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishOrCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishRaidCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishRenameCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishTimeCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishTypeCondition;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalConstants;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBiomeTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalBiomes;
import com.teamabnormals.environmental.core.registry.datapack.slabfish.EnvironmentalSlabfishBackpacks;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;

public class EnvironmentalSlabfishVariants {
    public static final ResourceKey<SlabfishVariant> SWAMP = EnvironmentalSlabfishVariants.create("swamp");
    public static final ResourceKey<SlabfishVariant> BADLANDS = EnvironmentalSlabfishVariants.create("badlands");
    public static final ResourceKey<SlabfishVariant> BAMBOO = EnvironmentalSlabfishVariants.create("bamboo");
    public static final ResourceKey<SlabfishVariant> BEACH = EnvironmentalSlabfishVariants.create("beach");
    public static final ResourceKey<SlabfishVariant> DARK_FOREST = EnvironmentalSlabfishVariants.create("dark_forest");
    public static final ResourceKey<SlabfishVariant> DESERT = EnvironmentalSlabfishVariants.create("desert");
    public static final ResourceKey<SlabfishVariant> FLOWER_FOREST = EnvironmentalSlabfishVariants.create("flower_forest");
    public static final ResourceKey<SlabfishVariant> FOREST = EnvironmentalSlabfishVariants.create("forest");
    public static final ResourceKey<SlabfishVariant> HILL = EnvironmentalSlabfishVariants.create("hill");
    public static final ResourceKey<SlabfishVariant> ICE_SPIKES = EnvironmentalSlabfishVariants.create("ice_spikes");
    public static final ResourceKey<SlabfishVariant> JUNGLE = EnvironmentalSlabfishVariants.create("jungle");
    public static final ResourceKey<SlabfishVariant> MANGROVE = EnvironmentalSlabfishVariants.create("mangrove");
    public static final ResourceKey<SlabfishVariant> MOUNTAIN = EnvironmentalSlabfishVariants.create("mountain");
    public static final ResourceKey<SlabfishVariant> PLAINS = EnvironmentalSlabfishVariants.create("plains");
    public static final ResourceKey<SlabfishVariant> RIVER = EnvironmentalSlabfishVariants.create("river");
    public static final ResourceKey<SlabfishVariant> SAVANNA = EnvironmentalSlabfishVariants.create("savanna");
    public static final ResourceKey<SlabfishVariant> SNOWY = EnvironmentalSlabfishVariants.create("snowy");
    public static final ResourceKey<SlabfishVariant> TAIGA = EnvironmentalSlabfishVariants.create("taiga");
    public static final ResourceKey<SlabfishVariant> CHERRY_GROVE = EnvironmentalSlabfishVariants.create("cherry_grove");
    public static final ResourceKey<SlabfishVariant> MARSH = EnvironmentalSlabfishVariants.create("marsh");
    public static final ResourceKey<SlabfishVariant> PINE = EnvironmentalSlabfishVariants.create("pine");
    public static final ResourceKey<SlabfishVariant> BLOSSOM = EnvironmentalSlabfishVariants.create("blossom");
    public static final ResourceKey<SlabfishVariant> RAINFOREST = EnvironmentalSlabfishVariants.create("rainforest");
    public static final ResourceKey<SlabfishVariant> DUNES = EnvironmentalSlabfishVariants.create("dunes");
    public static final ResourceKey<SlabfishVariant> SCRUBLAND = EnvironmentalSlabfishVariants.create("scrubland");
    public static final ResourceKey<SlabfishVariant> SPINY_THICKET = EnvironmentalSlabfishVariants.create("spiny_thicket");
    public static final ResourceKey<SlabfishVariant> ASPEN = EnvironmentalSlabfishVariants.create("aspen");
    public static final ResourceKey<SlabfishVariant> LAUREL = EnvironmentalSlabfishVariants.create("laurel");
    public static final ResourceKey<SlabfishVariant> KOUSA = EnvironmentalSlabfishVariants.create("kousa");
    public static final ResourceKey<SlabfishVariant> MAPLE = EnvironmentalSlabfishVariants.create("maple");
    public static final ResourceKey<SlabfishVariant> OCEAN = EnvironmentalSlabfishVariants.create("ocean");
    public static final ResourceKey<SlabfishVariant> WARM_OCEAN = EnvironmentalSlabfishVariants.create("warm_ocean");
    public static final ResourceKey<SlabfishVariant> FROZEN_OCEAN = EnvironmentalSlabfishVariants.create("frozen_ocean");
    public static final ResourceKey<SlabfishVariant> CAVE = EnvironmentalSlabfishVariants.create("cave");
    public static final ResourceKey<SlabfishVariant> DEEPSLATE = EnvironmentalSlabfishVariants.create("deepslate");
    public static final ResourceKey<SlabfishVariant> LUSH_CAVES = EnvironmentalSlabfishVariants.create("lush_caves");
    public static final ResourceKey<SlabfishVariant> DRIPSTONE_CAVES = EnvironmentalSlabfishVariants.create("dripstone_caves");
    public static final ResourceKey<SlabfishVariant> DEEP_DARK = EnvironmentalSlabfishVariants.create("deep_dark");
    public static final ResourceKey<SlabfishVariant> NETHER = EnvironmentalSlabfishVariants.create("nether");
    public static final ResourceKey<SlabfishVariant> CRIMSON = EnvironmentalSlabfishVariants.create("crimson");
    public static final ResourceKey<SlabfishVariant> WARPED = EnvironmentalSlabfishVariants.create("warped");
    public static final ResourceKey<SlabfishVariant> BASALT_DELTAS = EnvironmentalSlabfishVariants.create("basalt_deltas");
    public static final ResourceKey<SlabfishVariant> SOUL_SAND_VALLEY = EnvironmentalSlabfishVariants.create("soul_sand_valley");
    public static final ResourceKey<SlabfishVariant> GHOST = EnvironmentalSlabfishVariants.create("ghost");
    public static final ResourceKey<SlabfishVariant> END = EnvironmentalSlabfishVariants.create("end");
    public static final ResourceKey<SlabfishVariant> CHORUS = EnvironmentalSlabfishVariants.create("chorus");
    public static final ResourceKey<SlabfishVariant> POISE = EnvironmentalSlabfishVariants.create("poise");
    public static final ResourceKey<SlabfishVariant> MUSHROOM = EnvironmentalSlabfishVariants.create("mushroom");
    public static final ResourceKey<SlabfishVariant> BROWN_MUSHROOM = EnvironmentalSlabfishVariants.create("brown_mushroom");
    public static final ResourceKey<SlabfishVariant> DROWNED = EnvironmentalSlabfishVariants.create("drowned");
    public static final ResourceKey<SlabfishVariant> NIGHTMARE = EnvironmentalSlabfishVariants.create("nightmare");
    public static final ResourceKey<SlabfishVariant> SKY = EnvironmentalSlabfishVariants.create("sky");
    public static final ResourceKey<SlabfishVariant> SKELETON = EnvironmentalSlabfishVariants.create("skeleton");
    public static final ResourceKey<SlabfishVariant> STRAY = EnvironmentalSlabfishVariants.create("stray");
    public static final ResourceKey<SlabfishVariant> WITHER = EnvironmentalSlabfishVariants.create("wither");
    public static final ResourceKey<SlabfishVariant> TOTEM = EnvironmentalSlabfishVariants.create("totem");
    public static final ResourceKey<SlabfishVariant> GOLEM = EnvironmentalSlabfishVariants.create("golem");
    public static final ResourceKey<SlabfishVariant> SNAKE_BLOCK = EnvironmentalSlabfishVariants.create("snake_block");
    public static final List<ResourceKey<SlabfishVariant>> ATMOSPHERIC_SLABFISH = List.of(RAINFOREST, DUNES, SCRUBLAND, SPINY_THICKET, ASPEN, KOUSA, LAUREL);
    public static final List<ResourceKey<SlabfishVariant>> AUTUMNITY_SLABFISH = List.of(MAPLE);
    public static final List<ResourceKey<SlabfishVariant>> ENDERGETIC_SLABFISH = List.of(POISE);
    public static final List<ResourceKey<SlabfishVariant>> COMPAT_SLABFISH = Stream.concat(Stream.concat(ATMOSPHERIC_SLABFISH.stream(), AUTUMNITY_SLABFISH.stream()), ENDERGETIC_SLABFISH.stream()).collect(Collectors.toList());

    public static void bootstrap(BootstrapContext<SlabfishVariant> context) {
        EnvironmentalSlabfishVariants.register(context, SWAMP, -1, (TagKey<Biome>)Tags.Biomes.IS_SWAMP);
        EnvironmentalSlabfishVariants.register(context, BADLANDS, 0, (TagKey<Biome>)BiomeTags.IS_BADLANDS);
        EnvironmentalSlabfishVariants.register(context, BEACH, 0, EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.or(EnvironmentalSlabfishVariants.biome(context, (TagKey<Biome>)BiomeTags.IS_BEACH), EnvironmentalSlabfishVariants.biome(context, (ResourceKey<Biome>)Biomes.STONY_SHORE)));
        EnvironmentalSlabfishVariants.register(context, DESERT, 0, (ResourceKey<Biome>)Biomes.DESERT);
        EnvironmentalSlabfishVariants.register(context, FOREST, 0, (TagKey<Biome>)BiomeTags.IS_FOREST);
        EnvironmentalSlabfishVariants.register(context, HILL, 0, (TagKey<Biome>)BiomeTags.IS_HILL);
        EnvironmentalSlabfishVariants.register(context, JUNGLE, 0, (TagKey<Biome>)BiomeTags.IS_JUNGLE);
        EnvironmentalSlabfishVariants.register(context, OCEAN, 0, (TagKey<Biome>)BiomeTags.IS_OCEAN);
        EnvironmentalSlabfishVariants.register(context, PLAINS, 0, (TagKey<Biome>)Tags.Biomes.IS_PLAINS);
        EnvironmentalSlabfishVariants.register(context, RIVER, 0, (ResourceKey<Biome>)Biomes.RIVER);
        EnvironmentalSlabfishVariants.register(context, SAVANNA, 0, (TagKey<Biome>)BiomeTags.IS_SAVANNA);
        EnvironmentalSlabfishVariants.register(context, TAIGA, 0, (TagKey<Biome>)BiomeTags.IS_TAIGA);
        EnvironmentalSlabfishVariants.register(context, WARM_OCEAN, 1, (ResourceKey<Biome>)Biomes.WARM_OCEAN);
        EnvironmentalSlabfishVariants.register(context, BAMBOO, 1, (ResourceKey<Biome>)Biomes.BAMBOO_JUNGLE);
        EnvironmentalSlabfishVariants.register(context, CHERRY_GROVE, 1, (ResourceKey<Biome>)Biomes.CHERRY_GROVE);
        EnvironmentalSlabfishVariants.register(context, DARK_FOREST, 1, (ResourceKey<Biome>)Biomes.DARK_FOREST);
        EnvironmentalSlabfishVariants.register(context, FLOWER_FOREST, 1, (ResourceKey<Biome>)Biomes.FLOWER_FOREST);
        EnvironmentalSlabfishVariants.register(context, ICE_SPIKES, 1, (ResourceKey<Biome>)Biomes.ICE_SPIKES);
        EnvironmentalSlabfishVariants.register(context, MANGROVE, 1, (ResourceKey<Biome>)Biomes.MANGROVE_SWAMP);
        EnvironmentalSlabfishVariants.register(context, MOUNTAIN, 1, EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.or(EnvironmentalSlabfishVariants.biome(context, (ResourceKey<Biome>)Biomes.MEADOW), EnvironmentalSlabfishVariants.biome(context, (ResourceKey<Biome>)Biomes.STONY_PEAKS)));
        EnvironmentalSlabfishVariants.register(context, SNOWY, 1, (TagKey<Biome>)Tags.Biomes.IS_SNOWY);
        EnvironmentalSlabfishVariants.register(context, FROZEN_OCEAN, 2, EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.or(EnvironmentalSlabfishVariants.biome(context, (ResourceKey<Biome>)Biomes.FROZEN_OCEAN), EnvironmentalSlabfishVariants.biome(context, (ResourceKey<Biome>)Biomes.DEEP_FROZEN_OCEAN)));
        EnvironmentalSlabfishVariants.register(context, MUSHROOM, 2, EnvironmentalSlabfishVariants.or(EnvironmentalSlabfishVariants.and(EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.biome(context, (ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS)), EnvironmentalSlabfishVariants.and(new SlabfishEventCondition(SlabfishConditionContext.Event.LIGHTNING), new SlabfishTypeCondition(BROWN_MUSHROOM.location()))));
        EnvironmentalSlabfishVariants.register(context, BROWN_MUSHROOM, 2, new SlabfishEventCondition(SlabfishConditionContext.Event.LIGHTNING), new SlabfishTypeCondition(MUSHROOM.location()));
        EnvironmentalSlabfishVariants.register(context, TOTEM, 3, EnvironmentalSlabfishVariants.spawn(), new SlabfishRaidCondition());
        EnvironmentalSlabfishVariants.register(context, NIGHTMARE, 3, EnvironmentalSlabfishVariants.spawn(), new SlabfishInsomniaCondition(), new SlabfishTimeCondition(SlabfishConditionContext.Time.NIGHT));
        EnvironmentalSlabfishVariants.register(context, GOLEM, 0, new SlabfishImpossibleCondition());
        EnvironmentalSlabfishVariants.register(context, CAVE, 4, EnvironmentalSlabfishVariants.spawn(), new SlabfishHeightCondition(0, 48), new SlabfishLightCondition(0, 0, LightLayer.SKY), EnvironmentalSlabfishVariants.overworld());
        EnvironmentalSlabfishVariants.register(context, DEEPSLATE, 4, EnvironmentalSlabfishVariants.spawn(), new SlabfishHeightCondition(Integer.MIN_VALUE, 0), new SlabfishLightCondition(0, 0, LightLayer.SKY), EnvironmentalSlabfishVariants.overworld());
        EnvironmentalSlabfishVariants.register(context, SKY, 4, EnvironmentalSlabfishVariants.spawn(), new SlabfishHeightCondition(256, Integer.MAX_VALUE), EnvironmentalSlabfishVariants.overworld());
        EnvironmentalSlabfishVariants.register(context, LUSH_CAVES, 5, (ResourceKey<Biome>)Biomes.LUSH_CAVES);
        EnvironmentalSlabfishVariants.register(context, DRIPSTONE_CAVES, 5, (ResourceKey<Biome>)Biomes.DRIPSTONE_CAVES);
        EnvironmentalSlabfishVariants.register(context, DEEP_DARK, 5, (ResourceKey<Biome>)Biomes.DEEP_DARK);
        EnvironmentalSlabfishVariants.register(context, DROWNED, 10, EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.biome(context, (TagKey<Biome>)BiomeTags.IS_OCEAN), new SlabfishHeightCondition(Integer.MIN_VALUE, 48), new SlabfishInFluidCondition((HolderSet<Fluid>)context.lookup(Registries.FLUID).getOrThrow(FluidTags.WATER)));
        Holder.Reference<SlabfishVariant> skeleton = EnvironmentalSlabfishVariants.register(context, SKELETON, 10, new SlabfishEventCondition(SlabfishConditionContext.Event.LIGHTNING));
        EnvironmentalSlabfishVariants.register(context, STRAY, 10, new SlabfishEventCondition(SlabfishConditionContext.Event.BREED), new SlabfishBreedCondition((Holder<SlabfishVariant>)skeleton, (Holder<SlabfishVariant>)skeleton), EnvironmentalSlabfishVariants.biome(context, (TagKey<Biome>)Tags.Biomes.IS_SNOWY));
        EnvironmentalSlabfishVariants.register(context, WITHER, 10, new SlabfishEventCondition(SlabfishConditionContext.Event.BREED), new SlabfishBreedCondition((Holder<SlabfishVariant>)skeleton, (Holder<SlabfishVariant>)skeleton), EnvironmentalSlabfishVariants.dimension((ResourceKey<Level>)Level.NETHER));
        EnvironmentalSlabfishVariants.register(context, BLOSSOM, 1, EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.or(EnvironmentalSlabfishVariants.biome(context, EnvironmentalBiomes.BLOSSOM_WOODS), EnvironmentalSlabfishVariants.biome(context, EnvironmentalBiomes.BLOSSOM_VALLEYS)));
        EnvironmentalSlabfishVariants.register(context, MARSH, 1, EnvironmentalBiomes.MARSH);
        EnvironmentalSlabfishVariants.register(context, PINE, 1, EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.or(EnvironmentalSlabfishVariants.biome(context, EnvironmentalBiomeTags.IS_PINE_BARRENS), EnvironmentalSlabfishVariants.biome(context, EnvironmentalBiomes.PINE_SLOPES)));
        EnvironmentalSlabfishVariants.register(context, DUNES, 0, "atmospheric", EnvironmentalBiomeTags.IS_DUNES);
        EnvironmentalSlabfishVariants.register(context, RAINFOREST, 1, "atmospheric", EnvironmentalBiomeTags.IS_RAINFOREST);
        EnvironmentalSlabfishVariants.register(context, ASPEN, 1, "atmospheric", EnvironmentalConstants.ASPEN_PARKLAND);
        EnvironmentalSlabfishVariants.register(context, LAUREL, 1, "atmospheric", EnvironmentalConstants.LAUREL_FOREST);
        EnvironmentalSlabfishVariants.register(context, SPINY_THICKET, 1, "atmospheric", EnvironmentalConstants.SPINY_THICKET);
        EnvironmentalSlabfishVariants.register(context, KOUSA, 2, "atmospheric", EnvironmentalConstants.KOUSA_JUNGLE);
        EnvironmentalSlabfishVariants.register(context, SCRUBLAND, 2, EnvironmentalSlabfishVariants.modLoaded("atmospheric"), EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.or(EnvironmentalSlabfishVariants.biome(EnvironmentalConstants.SCRUBLAND), EnvironmentalSlabfishVariants.biome(EnvironmentalConstants.SNOWY_SCRUBLAND)));
        EnvironmentalSlabfishVariants.register(context, MAPLE, 1, EnvironmentalSlabfishVariants.modLoaded("autumnity"), EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.or(EnvironmentalSlabfishVariants.biome(EnvironmentalConstants.MAPLE_FOREST), EnvironmentalSlabfishVariants.biome(EnvironmentalConstants.PUMPKIN_FIELDS)));
        EnvironmentalSlabfishVariants.register(context, NETHER, 0, EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.dimension((ResourceKey<Level>)Level.NETHER));
        EnvironmentalSlabfishVariants.register(context, CRIMSON, 1, (ResourceKey<Biome>)Biomes.CRIMSON_FOREST);
        EnvironmentalSlabfishVariants.register(context, WARPED, 1, (ResourceKey<Biome>)Biomes.WARPED_FOREST);
        EnvironmentalSlabfishVariants.register(context, SOUL_SAND_VALLEY, 1, (ResourceKey<Biome>)Biomes.SOUL_SAND_VALLEY);
        EnvironmentalSlabfishVariants.register(context, BASALT_DELTAS, 1, (ResourceKey<Biome>)Biomes.BASALT_DELTAS);
        EnvironmentalSlabfishVariants.register(context, GHOST, 0, new SlabfishImpossibleCondition());
        EnvironmentalSlabfishVariants.register(context, END, 0, EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.dimension((ResourceKey<Level>)Level.END));
        EnvironmentalSlabfishVariants.register(context, CHORUS, 1, (TagKey<Biome>)Tags.Biomes.IS_OUTER_END_ISLAND);
        EnvironmentalSlabfishVariants.register(context, POISE, 1, "endergetic", EnvironmentalConstants.POISE_FOREST);
        EnvironmentalSlabfishVariants.register(context, SNAKE_BLOCK, 15, (Holder<SlabfishBackpack>)context.lookup(EnvironmentalRegistries.SLABFISH_BACKPACK).getOrThrow(EnvironmentalSlabfishBackpacks.SNAKE_BLOCK), new SlabfishRenameCondition(new String[]{"snake", "snake block", "snakeblock"}, false));
    }

    public static Holder.Reference<SlabfishVariant> register(BootstrapContext<SlabfishVariant> context, ResourceKey<SlabfishVariant> key, int priority, SlabfishCondition ... conditions) {
        return EnvironmentalSlabfishVariants.register(context, key, priority, null, conditions);
    }

    public static Holder.Reference<SlabfishVariant> register(BootstrapContext<SlabfishVariant> context, ResourceKey<SlabfishVariant> key, int priority, Holder<SlabfishBackpack> customBackpack, SlabfishCondition ... conditions) {
        return context.register(key, (Object)new SlabfishVariant((Component)Component.translatable((String)Util.makeDescriptionId((String)"slabfish_variant", (ResourceLocation)key.location())), ResourceLocation.fromNamespaceAndPath((String)key.location().getNamespace(), (String)("variant/" + key.location().getPath())), Optional.ofNullable(customBackpack), priority, (SlabfishCondition[])Arrays.stream(conditions).toArray(SlabfishCondition[]::new)));
    }

    public static Holder.Reference<SlabfishVariant> register(BootstrapContext<SlabfishVariant> context, ResourceKey<SlabfishVariant> key, int priority, TagKey<Biome> biomes) {
        return EnvironmentalSlabfishVariants.register(context, key, priority, EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.biome(context, biomes));
    }

    public static Holder.Reference<SlabfishVariant> register(BootstrapContext<SlabfishVariant> context, ResourceKey<SlabfishVariant> key, int priority, ResourceKey<Biome> biome) {
        return EnvironmentalSlabfishVariants.register(context, key, priority, EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.biome(context, biome));
    }

    public static Holder.Reference<SlabfishVariant> register(BootstrapContext<SlabfishVariant> context, ResourceKey<SlabfishVariant> key, int priority, String modid, TagKey<Biome> biomes) {
        return EnvironmentalSlabfishVariants.register(context, key, priority, EnvironmentalSlabfishVariants.modLoaded(modid), EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.biome(context, biomes));
    }

    public static Holder.Reference<SlabfishVariant> register(BootstrapContext<SlabfishVariant> context, ResourceKey<SlabfishVariant> key, int priority, String modid, ResourceLocation biome) {
        return EnvironmentalSlabfishVariants.register(context, key, priority, EnvironmentalSlabfishVariants.modLoaded(modid), EnvironmentalSlabfishVariants.spawn(), EnvironmentalSlabfishVariants.biome(biome));
    }

    public static SlabfishEventCondition spawn() {
        return new SlabfishEventCondition(SlabfishConditionContext.Event.SPAWN, SlabfishConditionContext.Event.BREED);
    }

    public static SlabfishOrCondition or(SlabfishCondition ... conditions) {
        return new SlabfishOrCondition(conditions);
    }

    public static SlabfishAndCondition and(SlabfishCondition ... conditions) {
        return new SlabfishAndCondition(conditions);
    }

    public static SlabfishInBiomeCondition biome(BootstrapContext<SlabfishVariant> context, ResourceKey<Biome> biome) {
        return new SlabfishInBiomeCondition((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(biome)}));
    }

    public static SlabfishInBiomeCondition biome(BootstrapContext<SlabfishVariant> context, TagKey<Biome> biomes) {
        return new SlabfishInBiomeCondition((HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(biomes));
    }

    public static SlabfishInBiomeKeyCondition biome(ResourceLocation biome) {
        return new SlabfishInBiomeKeyCondition(biome);
    }

    public static SlabfishDimensionCondition dimension(ResourceKey<Level> dimension) {
        return new SlabfishDimensionCondition(dimension);
    }

    public static SlabfishDimensionCondition overworld() {
        return new SlabfishDimensionCondition((ResourceKey<Level>)Level.OVERWORLD);
    }

    public static SlabfishModLoadedCondition modLoaded(String modid) {
        return new SlabfishModLoadedCondition(modid);
    }

    public static ResourceKey<SlabfishVariant> create(String name) {
        return ResourceKey.create(EnvironmentalRegistries.SLABFISH_VARIANT, (ResourceLocation)Environmental.location(name));
    }
}

