/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeerModel<E extends AbstractDeer>
extends AgeableListModel<E> {
    private boolean hasAntlers;
    private float neckAngle;
    private float sprintAmount;
    private float hopAmount;
    private float hopAngle;
    public final ModelPart body;
    public final ModelPart neck;
    public final ModelPart head;
    public final ModelPart rightAntler;
    public final ModelPart leftAntler;
    public final ModelPart rightFrontLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart rightHindLeg;
    public final ModelPart leftHindLeg;
    public final ModelPart rightFrontBabyLeg;
    public final ModelPart leftFrontBabyLeg;
    public final ModelPart rightHindBabyLeg;
    public final ModelPart leftHindBabyLeg;

    public DeerModel(ModelPart root) {
        super(true, 14.5f, 2.0f);
        this.body = root.getChild("body");
        this.neck = root.getChild("neck");
        this.head = root.getChild("head");
        this.rightAntler = this.head.getChild("right_antler");
        this.leftAntler = this.head.getChild("left_antler");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightFrontBabyLeg = root.getChild("right_front_baby_leg");
        this.leftFrontBabyLeg = root.getChild("left_front_baby_leg");
        this.rightHindBabyLeg = root.getChild("right_hind_baby_leg");
        this.leftHindBabyLeg = root.getChild("left_hind_baby_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -9.0f, 8.0f, 8.0f, 17.0f), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 40).addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)8.0f));
        root.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 25).addBox(-2.5f, -10.0f, -2.0f, 5.0f, 10.0f, 5.0f), PartPose.offset((float)0.0f, (float)10.0f, (float)-7.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(33, 0).addBox(-2.5f, -5.0f, -4.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.05f)).texOffs(32, 25).addBox(-1.5f, -3.0f, -8.0f, 3.0f, 3.0f, 4.0f, false), PartPose.offset((float)0.0f, (float)0.0f, (float)-5.75f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(33, 0).mirror().addBox(-1.0f, -4.0f, 0.5f, 1.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(33, 0).addBox(0.0f, -4.0f, 0.5f, 1.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        head.addOrReplaceChild("right_antler", CubeListBuilder.create().texOffs(0, 39).mirror().addBox(-0.5f, -10.0f, 0.0f, 0.0f, 11.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.25f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        head.addOrReplaceChild("left_antler", CubeListBuilder.create().texOffs(0, 39).addBox(0.5f, -10.0f, 0.0f, 0.0f, 11.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.25f, (float)0.0f, (float)0.7854f, (float)0.0f));
        root.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(20, 25).mirror().addBox(-0.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f), PartPose.offset((float)-3.5f, (float)14.0f, (float)-5.0f));
        root.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(20, 25).addBox(-2.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f), PartPose.offset((float)3.5f, (float)14.0f, (float)-5.0f));
        root.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(20, 25).mirror().addBox(-0.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f), PartPose.offset((float)-3.5f, (float)14.0f, (float)6.0f));
        root.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(20, 25).addBox(-2.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f), PartPose.offset((float)3.5f, (float)14.0f, (float)6.0f));
        CubeDeformation cubedeformation = new CubeDeformation(0.0f, 3.0f, 0.0f);
        root.addOrReplaceChild("right_front_baby_leg", CubeListBuilder.create().texOffs(20, 25).mirror().addBox(-0.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.offset((float)-3.5f, (float)14.0f, (float)-5.0f));
        root.addOrReplaceChild("left_front_baby_leg", CubeListBuilder.create().texOffs(20, 25).addBox(-2.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.offset((float)3.5f, (float)14.0f, (float)-5.0f));
        root.addOrReplaceChild("right_hind_baby_leg", CubeListBuilder.create().texOffs(20, 25).mirror().addBox(-0.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.offset((float)-3.5f, (float)14.0f, (float)6.0f));
        root.addOrReplaceChild("left_hind_baby_leg", CubeListBuilder.create().texOffs(20, 25).addBox(-2.5f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.offset((float)3.5f, (float)14.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(E entity, float limbSwing, float limbSwingAmount, float partialTick) {
        boolean flag1;
        this.hasAntlers = ((AbstractDeer)((Object)entity)).hasAntlers();
        this.neckAngle = ((AbstractDeer)((Object)entity)).getNeckAngle(partialTick);
        this.hopAngle = ((AbstractDeer)((Object)entity)).getHopAngle(partialTick);
        this.hopAmount = ((AbstractDeer)((Object)entity)).getHopAmount(partialTick);
        this.sprintAmount = ((AbstractDeer)((Object)entity)).getSprintAmount(partialTick) * (1.0f - this.hopAmount);
        boolean flag = this.young;
        this.rightAntler.visible = flag1 = this.hasAntlers && !flag;
        this.leftAntler.visible = flag1;
        this.rightFrontLeg.visible = !flag;
        this.leftFrontLeg.visible = !flag;
        this.rightHindLeg.visible = !flag;
        this.leftHindLeg.visible = !flag;
        this.rightFrontBabyLeg.visible = flag;
        this.leftFrontBabyLeg.visible = flag;
        this.rightHindBabyLeg.visible = flag;
        this.leftHindBabyLeg.visible = flag;
        this.body.y = flag ? 8.0f : 14.0f;
        this.neck.y = flag ? 4.0f : 10.0f;
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float neckanglerad = this.neckAngle * ((float)Math.PI / 180);
        float eatamount = Mth.clamp((float)((this.neckAngle - 90.0f) / 40.0f), (float)0.0f, (float)1.0f);
        float noeatamount = 1.0f - eatamount;
        float noanimamount = Math.min(1.0f - this.sprintAmount, 1.0f - this.hopAmount);
        this.neck.xRot = neckanglerad;
        this.body.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.25f * limbSwingAmount * this.sprintAmount;
        if (this.hopAngle != 0.0f) {
            this.body.xRot += this.hopAngle;
        }
        this.neck.y += (float)Math.tan(this.body.xRot) * 7.0f;
        this.neck.z = -7.0f - (float)Math.tan(this.body.xRot) * 4.0f;
        this.head.y = 2.0f - (this.young ? 0.7f : 1.0f) * 11.0f * Mth.cos((float)neckanglerad) + this.neck.y;
        this.head.z = 1.5f - (this.young ? 0.6f : 1.0f) * 12.0f * Mth.sin((float)neckanglerad) + this.neck.z;
        this.head.xRot = headPitch * ((float)Math.PI / 180) * noeatamount;
        this.head.xRot += (Mth.sin((float)(ageInTicks * 0.7f)) * 0.15f + 0.65f) * eatamount;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180) * noeatamount;
        this.leftFrontLeg.y = this.rightFrontLeg.y = 14.0f + (float)Math.tan(this.body.xRot) * 5.0f;
        this.leftHindLeg.y = this.rightHindLeg.y = 14.0f - (float)Math.tan(this.body.xRot) * 6.0f;
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount * noanimamount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount * noanimamount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount * noanimamount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount * noanimamount;
        if (this.sprintAmount > 0.0f) {
            this.rightFrontLeg.xRot += (-0.5235988f + Mth.cos((float)(ageInTicks * 0.6662f + (float)Math.PI))) * limbSwingAmount * this.sprintAmount;
            this.leftFrontLeg.xRot += (-0.5235988f + Mth.cos((float)(ageInTicks * 0.6662f + (float)Math.PI + 0.6f))) * limbSwingAmount * this.sprintAmount;
            this.rightHindLeg.xRot += (0.5235988f + Mth.cos((float)(ageInTicks * 0.6662f + 0.6f))) * limbSwingAmount * this.sprintAmount;
            this.leftHindLeg.xRot += (0.5235988f + Mth.cos((float)(ageInTicks * 0.6662f))) * limbSwingAmount * this.sprintAmount;
        }
        if (this.hopAngle != 0.0f) {
            this.rightFrontLeg.xRot += -this.hopAngle * 3.0f;
            this.leftFrontLeg.xRot += -this.hopAngle * 3.0f * 0.85f;
            this.rightHindLeg.xRot += -this.hopAngle * 2.5f * 0.85f;
            this.leftHindLeg.xRot += -this.hopAngle * 2.5f;
        }
        if (this.young) {
            this.rightFrontBabyLeg.copyFrom(this.rightFrontLeg);
            this.leftFrontBabyLeg.copyFrom(this.leftFrontLeg);
            this.rightHindBabyLeg.copyFrom(this.rightHindLeg);
            this.leftHindBabyLeg.copyFrom(this.leftHindLeg);
            this.rightFrontBabyLeg.y -= 3.0f;
            this.leftFrontBabyLeg.y -= 3.0f;
            this.rightHindBabyLeg.y -= 3.0f;
            this.leftHindBabyLeg.y -= 3.0f;
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.neck, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.leftHindLeg, (Object)this.rightHindLeg, (Object)this.leftFrontBabyLeg, (Object)this.rightFrontBabyLeg, (Object)this.leftHindBabyLeg, (Object)this.rightHindBabyLeg);
    }
}

