/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.entity.animal.Duck;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DuckModel<T extends Duck>
extends AgeableListModel<T> {
    public ModelPart head;
    public ModelPart body;
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    public ModelPart rightWing;
    public ModelPart leftWing;

    public DuckModel(ModelPart root) {
        super(true, 10.5f, 1.0f, 2.0f, 2.0f, 24.0f);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
        this.rightWing = root.getChild("right_wing");
        this.leftWing = root.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -5.0f, -2.5f, 3.0f, 3.0f, 4.0f).texOffs(0, 7).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 2.0f, 3.0f).texOffs(14, 0).addBox(-1.5f, -3.0f, -4.5f, 3.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)-1.5f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 12).addBox(-2.5f, -0.25f, -6.75f, 5.0f, 4.0f, 10.0f).texOffs(0, 24).addBox(0.0f, -2.25f, 1.25f, 0.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)17.25f, (float)2.75f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(23, 0).addBox(-1.5f, 0.0f, -4.0f, 3.0f, 3.0f, 4.0f, true), PartPose.offset((float)-1.5f, (float)21.0f, (float)3.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(23, 0).addBox(-1.5f, 0.0f, -4.0f, 3.0f, 3.0f, 4.0f), PartPose.offset((float)1.5f, (float)21.0f, (float)3.0f));
        root.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(30, 15).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 7.0f, true), PartPose.offset((float)-2.5f, (float)17.0f, (float)0.0f));
        root.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(30, 15).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 7.0f), PartPose.offset((float)2.5f, (float)17.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightWing, (Object)this.leftWing);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        float f;
        super.prepareMobModel(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.rightWing.zRot = f = ((Duck)((Object)entityIn)).getWingRotation(partialTick);
        this.leftWing.zRot = -f;
        if (((Duck)((Object)entityIn)).isEating()) {
            this.head.xRot = ((Duck)((Object)entityIn)).getHeadLean(partialTick) * 2.5f;
        }
    }

    public void setupAnim(T duck, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)((Duck)((Object)duck)).tickCount;
        float f1 = ((Duck)((Object)duck)).getHeadLean(f);
        float f2 = 1.0f - f1;
        this.head.xRot = headPitch * ((float)Math.PI / 180) * f2;
        this.head.xRot += f1 * 1.4f + Mth.cos((float)ageInTicks) * 0.15f * f1;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180) * f2;
        this.head.y = 17.0f + f1;
        this.head.z = -1.5f - f1;
        if (!duck.isInWater()) {
            this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightLeg.y = 21.0f;
            this.leftLeg.y = 21.0f;
        } else {
            float f3 = !duck.isBaby() ? 0.2f : 0.4f;
            this.rightLeg.xRot = 0.5f + Mth.cos((float)(ageInTicks * f3)) * 0.8f * (limbSwingAmount + 0.2f);
            this.leftLeg.xRot = 0.5f + Mth.cos((float)(ageInTicks * f3 + (float)Math.PI)) * 0.8f * (limbSwingAmount + 0.2f);
            this.rightLeg.y = 19.0f;
            this.leftLeg.y = 19.0f;
        }
    }
}

