/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.teamabnormals.environmental.common.entity.animal.PineconeGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PineconeGolemModel<T extends PineconeGolem>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart nose;
    private final ModelPart rightArm;
    private final ModelPart leftArm;

    public PineconeGolemModel(ModelPart root) {
        this.root = root;
        this.nose = root.getChild("nose");
        this.rightArm = root.getChild("right_arm");
        this.leftArm = root.getChild("left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        root.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(30, 0).addBox(-1.0f, -5.0f, -6.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        root.addOrReplaceChild("sapling_1", CubeListBuilder.create().texOffs(4, 20).addBox(-4.0f, -7.0f, 0.0f, 8.0f, 7.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        root.addOrReplaceChild("sapling_2", CubeListBuilder.create().texOffs(4, 20).addBox(-4.0f, -7.0f, 0.0f, 8.0f, 7.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(-0.5f, -8.0f, -0.5f, 1.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)-5.0f, (float)23.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 20).addBox(-0.5f, -8.0f, -0.5f, 1.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)5.0f, (float)23.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.getMainHandItem().isEmpty()) {
            this.rightArm.y = 23.0f;
            this.leftArm.y = 23.0f;
            this.rightArm.z = 0.0f;
            this.leftArm.z = 0.0f;
            this.leftArm.xRot = this.rightArm.xRot = 0.8f + headPitch * ((float)Math.PI / 180) * 0.3f;
            this.rightArm.yRot = Mth.cos((float)limbSwing) * 0.8f * limbSwingAmount + 1.5707964f;
            this.leftArm.yRot = Mth.cos((float)limbSwing) * 0.8f * limbSwingAmount - 1.5707964f;
        } else {
            this.rightArm.y = 22.0f;
            this.leftArm.y = 22.0f;
            this.rightArm.z = -4.5f;
            this.leftArm.z = -4.5f;
            this.rightArm.xRot = 0.8f;
            this.leftArm.xRot = 0.8f;
            this.rightArm.yRot = -0.6f;
            this.leftArm.yRot = 0.6f;
        }
    }
}

