/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.entity.animal.Tapir;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class TapirModel<T extends Tapir>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart snout;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;

    public TapirModel(ModelPart root) {
        super(false, 4.0f, 4.0f, 2.0f, 2.0f, 24.0f);
        this.head = root.getChild("head");
        this.snout = this.head.getChild("snout");
        this.body = root.getChild("body");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightHindLeg = root.getChild("right_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -6.0f, 8.0f, 7.0f, 7.0f).texOffs(30, 9).mirror().addBox(3.0f, -6.0f, -2.0f, 3.0f, 4.0f, 1.0f).mirror(false).texOffs(30, 9).addBox(-6.0f, -6.0f, -2.0f, 3.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)11.0f, (float)-8.0f));
        head.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(30, 0).addBox(-2.0f, -3.0f, -4.0f, 4.0f, 5.0f, 4.0f).texOffs(46, 1).addBox(-2.0f, -3.0f, -6.0f, 4.0f, 6.0f, 2.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)-5.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 14).addBox(-5.0f, -1.0f, -5.0f, 10.0f, 19.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)-8.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(30, 14).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f), PartPose.offset((float)3.0f, (float)18.0f, (float)-6.0f));
        root.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(30, 14).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f), PartPose.offset((float)-3.0f, (float)18.0f, (float)-6.0f));
        root.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(30, 14).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f), PartPose.offset((float)3.0f, (float)18.0f, (float)6.0f));
        root.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(30, 14).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f), PartPose.offset((float)-3.0f, (float)18.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public void setupAnim(T tapir, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)((Tapir)((Object)tapir)).tickCount;
        float snoutraiseanim = ((Tapir)((Object)tapir)).getSnoutRaiseAmount(partialTick);
        float shakeheadanim = ((Tapir)((Object)tapir)).getHeadShakeAnim(partialTick);
        float neckangle = ((Tapir)((Object)tapir)).getNeckAngle(partialTick);
        float noanimamount = 1.0f - ((Tapir)((Object)tapir)).getNoAnimAmount(partialTick);
        this.head.y = 11.0f;
        this.head.z = -8.0f;
        this.head.xRot = headPitch * ((float)Math.PI / 180) * noanimamount;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.snout.xRot = 0.0f;
        this.snout.yRot = 0.0f;
        this.head.y += neckangle;
        this.head.z += -neckangle;
        this.head.xRot += neckangle * 0.7f;
        if (((Tapir)((Object)tapir)).isSniffing()) {
            this.head.xRot += Mth.sin((float)(ageInTicks * 0.8f)) * 0.015f;
            this.snout.xRot = Mth.sin((float)(ageInTicks * 0.7f)) * Mth.sin((float)(ageInTicks * 0.2f)) * 0.3f;
            this.snout.yRot = Mth.cos((float)(ageInTicks * 0.6f)) * 0.05f;
        } else if (((Tapir)((Object)tapir)).isGrazing()) {
            this.head.xRot += Mth.sin((float)(ageInTicks * 0.5f)) * 0.05f;
            this.snout.xRot = Mth.sin((float)(ageInTicks * 0.5f)) * 0.3f;
        }
        this.snout.xRot += -0.4f * snoutraiseanim;
        if (shakeheadanim > 0.0f) {
            this.head.yRot = Mth.sin((float)(shakeheadanim * (float)Math.PI / 4.0f)) * 0.3f * noanimamount;
        }
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }
}

