/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zebroid;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ZebraModel<T extends AbstractHorse>
extends AgeableListModel<T> {
    protected boolean isHybrid = false;
    protected final ModelPart body;
    protected final ModelPart headParts;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindBabyLeg;
    private final ModelPart leftHindBabyLeg;
    private final ModelPart rightFrontBabyLeg;
    private final ModelPart leftFrontBabyLeg;
    private final ModelPart tail;
    private final ModelPart[] saddleParts;
    private final ModelPart[] ridingParts;

    public ZebraModel(ModelPart part) {
        super(true, 16.2f, 1.36f, 2.7272f, 2.0f, 20.0f);
        this.body = part.getChild("body");
        this.headParts = part.getChild("head_parts");
        this.rightHindLeg = part.getChild("right_hind_leg");
        this.leftHindLeg = part.getChild("left_hind_leg");
        this.rightFrontLeg = part.getChild("right_front_leg");
        this.leftFrontLeg = part.getChild("left_front_leg");
        this.rightHindBabyLeg = part.getChild("right_hind_baby_leg");
        this.leftHindBabyLeg = part.getChild("left_hind_baby_leg");
        this.rightFrontBabyLeg = part.getChild("right_front_baby_leg");
        this.leftFrontBabyLeg = part.getChild("left_front_baby_leg");
        this.tail = this.body.getChild("tail");
        ModelPart modelpart = this.body.getChild("saddle");
        ModelPart modelpart1 = this.headParts.getChild("left_saddle_mouth");
        ModelPart modelpart2 = this.headParts.getChild("right_saddle_mouth");
        ModelPart modelpart3 = this.headParts.getChild("left_saddle_line");
        ModelPart modelpart4 = this.headParts.getChild("right_saddle_line");
        ModelPart modelpart5 = this.headParts.getChild("head_saddle");
        ModelPart modelpart6 = this.headParts.getChild("mouth_saddle_wrap");
        this.saddleParts = new ModelPart[]{modelpart, modelpart1, modelpart2, modelpart5, modelpart6};
        this.ridingParts = new ModelPart[]{modelpart3, modelpart4};
    }

    public static MeshDefinition createBodyMesh(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 35).addBox(-4.5f, -6.0f, -17.0f, 9.0f, 9.0f, 20.0f, new CubeDeformation(0.05f)), PartPose.offset((float)0.0f, (float)10.0f, (float)5.5f));
        PartDefinition headParts = partdefinition.addOrReplaceChild("head_parts", CubeListBuilder.create().texOffs(0, 38).addBox(-2.05f, -6.0f, -3.0f, 4.0f, 11.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-12.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition head = headParts.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -11.0f, -4.0f, 6.0f, 5.0f, 7.0f, deformation), PartPose.ZERO);
        headParts.addOrReplaceChild("mane", CubeListBuilder.create().texOffs(50, 36).addBox(-1.0f, -11.0f, 3.01f, 2.0f, 15.0f, 3.0f, deformation), PartPose.ZERO);
        headParts.addOrReplaceChild("upper_mouth", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, -11.0f, -9.0f, 4.0f, 5.0f, 5.0f, deformation), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 23).mirror().addBox(-2.5f, -0.01f, -1.5f, 3.0f, 10.0f, 3.0f, deformation), PartPose.offset((float)4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(48, 23).addBox(-0.5f, -0.01f, -1.5f, 3.0f, 10.0f, 3.0f, deformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 23).mirror().addBox(-2.5f, -0.01f, -1.4f, 3.0f, 10.0f, 3.0f, deformation), PartPose.offset((float)4.0f, (float)14.0f, (float)-10.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(48, 23).addBox(-0.5f, -0.01f, -1.4f, 3.0f, 10.0f, 3.0f, deformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)-10.0f));
        CubeDeformation cubedeformation = deformation.extend(0.0f, 5.0f, 0.0f);
        partdefinition.addOrReplaceChild("left_hind_baby_leg", CubeListBuilder.create().texOffs(48, 23).mirror().addBox(-2.5f, -0.01f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.offset((float)4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_hind_baby_leg", CubeListBuilder.create().texOffs(48, 23).addBox(-0.5f, -0.01f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_front_baby_leg", CubeListBuilder.create().texOffs(48, 23).mirror().addBox(-2.5f, -0.01f, 0.1f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.offset((float)4.0f, (float)14.0f, (float)-12.0f));
        partdefinition.addOrReplaceChild("right_front_baby_leg", CubeListBuilder.create().texOffs(48, 23).addBox(-0.5f, -0.01f, 0.1f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)-12.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(38, 38).addBox(-1.5f, -1.0f, 0.5f, 3.0f, 14.0f, 3.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)3.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("saddle", CubeListBuilder.create().texOffs(26, 0).addBox(-4.5f, -6.0f, -9.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        headParts.addOrReplaceChild("left_saddle_mouth", CubeListBuilder.create().texOffs(29, 5).addBox(2.0f, -10.0f, -7.0f, 1.0f, 2.0f, 2.0f, deformation), PartPose.ZERO);
        headParts.addOrReplaceChild("right_saddle_mouth", CubeListBuilder.create().texOffs(29, 5).addBox(-3.0f, -10.0f, -7.0f, 1.0f, 2.0f, 2.0f, deformation), PartPose.ZERO);
        headParts.addOrReplaceChild("left_saddle_line", CubeListBuilder.create().texOffs(32, 2).addBox(3.1f, -6.5f, -9.5f, 0.0f, 3.0f, 16.0f, deformation), PartPose.rotation((float)-0.5235988f, (float)0.0f, (float)0.0f));
        headParts.addOrReplaceChild("right_saddle_line", CubeListBuilder.create().texOffs(32, 2).addBox(-3.1f, -6.5f, -9.5f, 0.0f, 3.0f, 16.0f, deformation), PartPose.rotation((float)-0.5235988f, (float)0.0f, (float)0.0f));
        headParts.addOrReplaceChild("head_saddle", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -11.0f, -3.9f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.2f)), PartPose.ZERO);
        headParts.addOrReplaceChild("mouth_saddle_wrap", CubeListBuilder.create().texOffs(19, 0).addBox(-2.0f, -11.0f, -6.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.ZERO);
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(19, 19).addBox(0.55f, -14.0f, 2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.ZERO);
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(19, 19).addBox(-2.55f, -14.0f, 2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.ZERO);
        return meshdefinition;
    }

    public void setupAnim(T zebra, float p_102786_, float p_102787_, float p_102788_, float p_102789_, float p_102790_) {
        boolean isSaddled = zebra.isSaddled();
        boolean isVehicle = zebra.isVehicle();
        for (ModelPart modelpart : this.saddleParts) {
            modelpart.visible = isSaddled;
        }
        for (ModelPart modelpart1 : this.ridingParts) {
            modelpart1.visible = isVehicle && isSaddled;
        }
    }

    public Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.headParts);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindBabyLeg, (Object)this.leftHindBabyLeg, (Object)this.rightFrontBabyLeg, (Object)this.leftFrontBabyLeg);
    }

    public void prepareMobModel(T zebra, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(zebra, limbSwing, limbSwingAmount, partialTick);
        float bodyrot = Mth.rotLerp((float)partialTick, (float)((AbstractHorse)zebra).yBodyRotO, (float)((AbstractHorse)zebra).yBodyRot);
        float headrot = Mth.rotLerp((float)partialTick, (float)((AbstractHorse)zebra).yHeadRotO, (float)((AbstractHorse)zebra).yHeadRot);
        float headyangle = headrot - bodyrot;
        float headswing = Mth.lerp((float)partialTick, (float)((AbstractHorse)zebra).xRotO, (float)zebra.getXRot()) * ((float)Math.PI / 180);
        if (headyangle > 20.0f) {
            headyangle = 20.0f;
        }
        if (headyangle < -20.0f) {
            headyangle = -20.0f;
        }
        if (limbSwingAmount > 0.2f) {
            headswing += Mth.cos((float)(limbSwing * 0.8f)) * 0.15f * limbSwingAmount;
        }
        float eatanim = zebra.getEatAnim(partialTick);
        float standanim = zebra.getStandAnim(partialTick);
        float nostandanim = 1.0f - standanim;
        float mouthanim = zebra.getMouthAnim(partialTick);
        boolean movingtail = ((AbstractHorse)zebra).tailCounter != 0;
        float ageinticks = (float)((AbstractHorse)zebra).tickCount + partialTick;
        this.headParts.y = this.isHybrid ? 4.0f : 6.0f;
        this.headParts.z = this.isHybrid ? -12.0f : -10.5f;
        this.body.xRot = 0.0f;
        this.headParts.xRot = 0.5235988f + headswing;
        this.headParts.yRot = headyangle * ((float)Math.PI / 180);
        float legswingspeed = zebra.isInWater() ? 0.2f : 1.0f;
        float hindlegswing = Mth.cos((float)(legswingspeed * limbSwing * 0.6662f + (float)Math.PI));
        float frontlegswing = hindlegswing * 0.8f * limbSwingAmount;
        float headxangle = (1.0f - Math.max(standanim, eatanim)) * (0.5235988f + headswing + mouthanim * Mth.sin((float)ageinticks) * 0.05f);
        this.headParts.xRot = standanim * (0.2617994f + headswing) + eatanim * (2.1816616f + Mth.sin((float)ageinticks) * 0.05f) + headxangle;
        this.headParts.yRot = standanim * headyangle * ((float)Math.PI / 180) + (1.0f - Math.max(standanim, eatanim)) * this.headParts.yRot;
        this.headParts.y = standanim * -4.0f + eatanim * 11.0f + (1.0f - Math.max(standanim, eatanim)) * this.headParts.y;
        this.headParts.z = standanim * -4.0f + eatanim * -12.0f + (1.0f - Math.max(standanim, eatanim)) * this.headParts.z;
        this.body.xRot = standanim * -0.7853982f + nostandanim * this.body.xRot;
        float standlegangle = 0.2617994f * standanim;
        float standswing = Mth.cos((float)(ageinticks * 0.6f + (float)Math.PI));
        this.leftFrontLeg.y = 2.0f * standanim + 14.0f * nostandanim;
        this.leftFrontLeg.z = -6.0f * standanim - 10.0f * nostandanim;
        float leftfrontlegangle = (-1.0471976f + standswing) * standanim + frontlegswing * nostandanim;
        float rightfrontlegangle = (-1.0471976f - standswing) * standanim - frontlegswing * nostandanim;
        this.leftHindLeg.xRot = standlegangle - hindlegswing * 0.5f * limbSwingAmount * nostandanim;
        this.rightHindLeg.xRot = standlegangle + hindlegswing * 0.5f * limbSwingAmount * nostandanim;
        this.leftFrontLeg.xRot = leftfrontlegangle;
        this.rightFrontLeg.xRot = rightfrontlegangle;
        this.tail.xRot = 0.5235988f + limbSwingAmount * 0.75f;
        this.tail.y = (this.isHybrid ? -5.0f : -2.5f) + limbSwingAmount;
        this.tail.z = (this.isHybrid ? 2.0f : 1.0f) + limbSwingAmount * 2.0f;
        float backkickbodyrot = ((Zebroid)zebra).getBackKickBodyRot(partialTick);
        float backkicklegrot = ((Zebroid)zebra).getBackKickLegRot(partialTick);
        backkickbodyrot *= nostandanim;
        backkicklegrot *= nostandanim;
        float frontkickbodyrot = ((Zebroid)zebra).getFrontKickBodyRot(partialTick);
        float frontkicklegrot = ((Zebroid)zebra).getFrontKickLegRot(partialTick);
        frontkickbodyrot *= nostandanim;
        frontkicklegrot *= nostandanim;
        this.body.y = 11.0f;
        this.body.z = this.isHybrid ? 5.0f : 5.5f;
        this.leftHindLeg.y = 14.0f;
        this.leftHindLeg.z = 7.0f;
        this.headParts.y += backkickbodyrot;
        this.headParts.z += -3.5f * backkickbodyrot;
        this.headParts.xRot += 0.15f * backkickbodyrot;
        this.body.y += -14.0f * Mth.sin((float)(0.5235988f * backkickbodyrot));
        this.body.z += 14.0f * Mth.cos((float)(0.5235988f * backkickbodyrot)) - 14.0f - backkickbodyrot;
        this.body.xRot += 0.5235988f * backkickbodyrot;
        this.leftHindLeg.y += -9.5f * backkickbodyrot;
        this.leftHindLeg.z += -backkickbodyrot;
        this.rightHindLeg.y = this.leftHindLeg.y;
        this.rightHindLeg.z = this.leftHindLeg.z;
        this.leftHindLeg.xRot += 1.7278761f * backkicklegrot;
        this.rightHindLeg.xRot += 1.7278761f * backkicklegrot;
        this.headParts.y += -6.0f * frontkickbodyrot;
        this.headParts.z += 4.0f * frontkickbodyrot;
        this.headParts.xRot += -0.1f * frontkickbodyrot;
        this.body.xRot += -0.5235988f * frontkickbodyrot;
        this.leftHindLeg.xRot += 0.2f * frontkickbodyrot;
        this.rightHindLeg.xRot += 0.2f * frontkickbodyrot;
        this.leftFrontLeg.y += -9.0f * frontkickbodyrot;
        this.leftFrontLeg.z += frontkickbodyrot;
        this.rightFrontLeg.y = this.leftFrontLeg.y;
        this.rightFrontLeg.z = this.leftFrontLeg.z;
        this.leftFrontLeg.xRot += (-1.7278761f + standswing * 0.3f) * frontkicklegrot;
        this.rightFrontLeg.xRot += (-1.7278761f - standswing * 0.3f) * frontkicklegrot;
        this.tail.yRot = movingtail ? Mth.cos((float)(ageinticks * 0.7f)) : 0.0f;
        this.rightHindBabyLeg.y = this.rightHindLeg.y;
        this.rightHindBabyLeg.z = this.rightHindLeg.z;
        this.rightHindBabyLeg.xRot = this.rightHindLeg.xRot;
        this.leftHindBabyLeg.y = this.leftHindLeg.y;
        this.leftHindBabyLeg.z = this.leftHindLeg.z;
        this.leftHindBabyLeg.xRot = this.leftHindLeg.xRot;
        this.rightFrontBabyLeg.y = this.rightFrontLeg.y;
        this.rightFrontBabyLeg.z = this.rightFrontLeg.z;
        this.rightFrontBabyLeg.xRot = this.rightFrontLeg.xRot;
        this.leftFrontBabyLeg.y = this.leftFrontLeg.y;
        this.leftFrontBabyLeg.z = this.leftFrontLeg.z;
        this.leftFrontBabyLeg.xRot = this.leftFrontLeg.xRot;
        boolean isbaby = zebra.isBaby();
        this.rightHindLeg.visible = !isbaby;
        this.leftHindLeg.visible = !isbaby;
        this.rightFrontLeg.visible = !isbaby;
        this.leftFrontLeg.visible = !isbaby;
        this.rightHindBabyLeg.visible = isbaby;
        this.leftHindBabyLeg.visible = isbaby;
        this.rightFrontBabyLeg.visible = isbaby;
        this.leftFrontBabyLeg.visible = isbaby;
    }
}

