/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.teamabnormals.environmental.client.model.ZebraModel;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zonkey;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ZonkeyModel<T extends Zonkey>
extends ZebraModel<T> {
    private final ModelPart leftChest;
    private final ModelPart rightChest;

    public ZonkeyModel(ModelPart part) {
        super(part);
        this.leftChest = this.body.getChild("left_chest");
        this.rightChest = this.body.getChild("right_chest");
        this.isHybrid = true;
    }

    public static MeshDefinition createBodyMesh(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-5.0f, -8.0f, -17.0f, 10.0f, 10.0f, 22.0f, new CubeDeformation(0.05f)), PartPose.offset((float)0.0f, (float)11.0f, (float)5.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(26, 21).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 8.0f, 3.0f);
        partdefinition1.addOrReplaceChild("left_chest", cubelistbuilder, PartPose.offsetAndRotation((float)6.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
        partdefinition1.addOrReplaceChild("right_chest", cubelistbuilder, PartPose.offsetAndRotation((float)-6.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        PartDefinition partdefinition2 = partdefinition.addOrReplaceChild("head_parts", CubeListBuilder.create().texOffs(0, 35).addBox(-2.05f, -6.0f, -2.0f, 4.0f, 12.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-12.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition3 = partdefinition2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 13).addBox(-3.0f, -11.0f, -2.0f, 6.0f, 5.0f, 7.0f, deformation), PartPose.ZERO);
        partdefinition2.addOrReplaceChild("mane", CubeListBuilder.create().texOffs(56, 36).addBox(-1.0f, -11.0f, 5.01f, 2.0f, 16.0f, 2.0f, deformation), PartPose.ZERO);
        partdefinition2.addOrReplaceChild("upper_mouth", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -11.0f, -7.0f, 4.0f, 5.0f, 5.0f, deformation), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, deformation), PartPose.offset((float)4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, deformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, deformation), PartPose.offset((float)4.0f, (float)14.0f, (float)-12.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, deformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)-12.0f));
        CubeDeformation cubedeformation = deformation.extend(0.0f, 5.5f, 0.0f);
        partdefinition.addOrReplaceChild("left_hind_baby_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset((float)4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_hind_baby_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_front_baby_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset((float)4.0f, (float)14.0f, (float)-12.0f));
        partdefinition.addOrReplaceChild("right_front_baby_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)-12.0f));
        partdefinition1.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(42, 36).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 4.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)2.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        partdefinition1.addOrReplaceChild("saddle", CubeListBuilder.create().texOffs(26, 0).addBox(-5.0f, -8.0f, -9.0f, 10.0f, 9.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        partdefinition2.addOrReplaceChild("left_saddle_mouth", CubeListBuilder.create().texOffs(29, 5).addBox(2.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, deformation), PartPose.ZERO);
        partdefinition2.addOrReplaceChild("right_saddle_mouth", CubeListBuilder.create().texOffs(29, 5).addBox(-3.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, deformation), PartPose.ZERO);
        partdefinition2.addOrReplaceChild("left_saddle_line", CubeListBuilder.create().texOffs(32, 2).addBox(3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.rotation((float)-0.5235988f, (float)0.0f, (float)0.0f));
        partdefinition2.addOrReplaceChild("right_saddle_line", CubeListBuilder.create().texOffs(32, 2).addBox(-3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.rotation((float)-0.5235988f, (float)0.0f, (float)0.0f));
        partdefinition2.addOrReplaceChild("head_saddle", CubeListBuilder.create().texOffs(1, 1).addBox(-3.0f, -11.0f, -1.9f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.22f)), PartPose.ZERO);
        partdefinition2.addOrReplaceChild("mouth_saddle_wrap", CubeListBuilder.create().texOffs(19, 0).addBox(-2.0f, -11.0f, -4.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.ZERO);
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -7.0f, 0.0f, 2.0f, 7.0f, 1.0f);
        partdefinition3.addOrReplaceChild("left_ear", cubelistbuilder1, PartPose.offsetAndRotation((float)1.25f, (float)-10.0f, (float)4.0f, (float)0.2617994f, (float)0.0f, (float)0.2617994f));
        partdefinition3.addOrReplaceChild("right_ear", cubelistbuilder1, PartPose.offsetAndRotation((float)-1.25f, (float)-10.0f, (float)4.0f, (float)0.2617994f, (float)0.0f, (float)-0.2617994f));
        return meshdefinition;
    }

    @Override
    public void setupAnim(T zonkey, float p_102367_, float p_102368_, float p_102369_, float p_102370_, float p_102371_) {
        super.setupAnim(zonkey, p_102367_, p_102368_, p_102369_, p_102370_, p_102371_);
        if (zonkey.hasChest()) {
            this.leftChest.visible = true;
            this.rightChest.visible = true;
        } else {
            this.leftChest.visible = false;
            this.rightChest.visible = false;
        }
    }
}

