/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LightLayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlumBlossomParticle
extends TextureSheetParticle {
    private final float rotSpeed;
    private int waterTicks;
    private boolean isInWater;
    private boolean thunder;
    private boolean rain;

    private PlumBlossomParticle(ClientLevel level, double xCoordIn, double yCoordIn, double zCoordIn) {
        super(level, xCoordIn, yCoordIn, zCoordIn);
        this.quadSize *= 1.75f;
        this.lifetime = 500 + this.random.nextInt(200) + this.random.nextInt(200);
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.roll = (float)Math.random() * ((float)Math.PI * 2);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            float mult;
            float f = mult = this.onGround ? 0.02f + this.random.nextFloat() * 0.1f : 1.0f;
            if (this.thunder) {
                this.xd -= (double)(0.0125f * mult);
                this.yd -= (double)(0.0075f * mult);
            } else if (this.rain) {
                this.xd -= (double)(0.001f * mult);
            }
            this.stoppedByCollision = false;
            this.move(this.xd, this.yd, this.zd);
            this.yd -= (double)0.001f;
            this.yd = Math.max(this.yd, (double)-0.08f);
            this.oRoll = this.roll;
            if (!this.isInWater) {
                this.isInWater = this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).getFluidState().is(FluidTags.WATER);
            } else {
                ++this.waterTicks;
            }
            if (!(this.onGround || this.isInWater && this.waterTicks >= 1)) {
                this.roll += (float)Math.PI * this.rotSpeed * (this.thunder ? 2.6f : (this.rain ? 2.0f : 1.6f));
            }
            if (this.isInWater && this.waterTicks >= 1) {
                this.yd = 0.0;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PlumBlossomParticle particle = new PlumBlossomParticle(level, x, y, z);
            particle.pickSprite(this.spriteSet);
            if (level.getBrightness(LightLayer.SKY, BlockPos.containing((double)x, (double)y, (double)z)) > 8) {
                particle.rain = level.isRaining();
                particle.thunder = level.isThundering();
            }
            return particle;
        }
    }
}

