/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.environmental.client.model.DuckModel;
import com.teamabnormals.environmental.common.entity.animal.Duck;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DuckRenderer
extends MobRenderer<Duck, DuckModel<Duck>> {
    private static final ResourceLocation DUCK = Environmental.location("textures/entity/duck/duck.png");
    private static final ResourceLocation DUCKLING = Environmental.location("textures/entity/duck/duckling.png");

    public DuckRenderer(EntityRendererProvider.Context context) {
        super(context, new DuckModel(context.bakeLayer(EnvironmentalModelLayers.DUCK)), 0.3f);
    }

    public ResourceLocation getTextureLocation(Duck duck) {
        return duck.isBaby() ? DUCKLING : DUCK;
    }

    protected void setupRotations(Duck duck, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        if (duck.isInWater()) {
            poseStack.translate(0.0, (double)(Mth.cos((float)(ageInTicks * 0.08f)) * 0.02f), 0.0);
        }
        super.setupRotations((LivingEntity)duck, poseStack, ageInTicks, rotationYaw, partialTicks, scale);
    }
}

