/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.environmental.client.model.PineconeGolemModel;
import com.teamabnormals.environmental.client.renderer.entity.layers.PineconeGolemHeldItemLayer;
import com.teamabnormals.environmental.common.entity.animal.PineconeGolem;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PineconeGolemRenderer
extends MobRenderer<PineconeGolem, PineconeGolemModel<PineconeGolem>> {
    private static final ResourceLocation PINECONE_GOLEM_LOCATION = Environmental.location("textures/entity/pinecone_golem.png");

    public PineconeGolemRenderer(EntityRendererProvider.Context context) {
        super(context, new PineconeGolemModel(context.bakeLayer(EnvironmentalModelLayers.PINECONE_GOLEM)), 0.4f);
        this.addLayer(new PineconeGolemHeldItemLayer((RenderLayerParent<PineconeGolem, PineconeGolemModel<PineconeGolem>>)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(PineconeGolem pineconeGolem) {
        return PINECONE_GOLEM_LOCATION;
    }

    protected void setupRotations(PineconeGolem pineconeGolem, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)pineconeGolem, poseStack, ageInTicks, rotationYaw, partialTicks, scale);
        float limbswing = pineconeGolem.walkAnimation.position() - pineconeGolem.walkAnimation.speed() * (1.0f - partialTicks);
        float limbswingamount = Math.min(Mth.lerp((float)partialTicks, (float)pineconeGolem.walkAnimation.speedOld, (float)pineconeGolem.walkAnimation.speed()), 1.0f);
        float yRot = Mth.cos((float)(limbswing + (float)Math.PI)) * 0.15f * limbswingamount;
        poseStack.mulPose(Axis.YP.rotation(yRot));
    }
}

