/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.client.model.SlabfishModel;
import com.teamabnormals.environmental.client.resources.SlabfishSpriteUploader;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.entity.animal.slabfish.SlabfishOverlay;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BackpackOverlayRenderLayer<E extends Slabfish, M extends SlabfishModel<E>>
extends RenderLayer<E, M> {
    public BackpackOverlayRenderLayer(RenderLayerParent<E, M> entityRenderer) {
        super(entityRenderer);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn, E slabfish, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Optional<Holder<SlabfishOverlay>> overlay = ((Slabfish)((Object)slabfish)).getOverlay();
        if (!((Slabfish)((Object)slabfish)).hasBackpack() || overlay.isEmpty() || ((SlabfishOverlay)overlay.get().value()).backpackTexture().isEmpty()) {
            return;
        }
        VertexConsumer builder = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)SlabfishSpriteUploader.ATLAS_LOCATION));
        ((SlabfishModel)this.getParentModel()).sprite = SlabfishSpriteUploader.instance().getSprite(((SlabfishOverlay)overlay.get().value()).backpackTexture().get());
        ((SlabfishModel)this.getParentModel()).setupAnim(slabfish, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ((SlabfishModel)this.getParentModel()).renderToBuffer(matrixStack, builder, packedLightIn, OverlayTexture.NO_OVERLAY);
    }
}

