/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.Lists;
import com.teamabnormals.environmental.common.block.WallHibiscusBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractHibiscusBlock
extends FlowerBlock
implements BonemealableBlock {
    public AbstractHibiscusBlock(Holder<MobEffect> stewEffect, int stewEffectDuration, BlockBehaviour.Properties properties) {
        super(stewEffect, (float)stewEffectDuration, properties);
    }

    protected Block getWallHibiscus() {
        return null;
    }

    public boolean isValidBonemealTarget(LevelReader blockGetter, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlockAndUpdate(pos, ((Block)EnvironmentalBlocks.HIBISCUS_LEAVES.get()).defaultBlockState());
        ArrayList validdirections = Lists.newArrayList();
        int i = 2 + random.nextInt(2) + random.nextInt(2);
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.relative(direction);
            if (!level.getBlockState(blockpos).isAir()) continue;
            validdirections.add(direction);
        }
        for (int j = 0; j < i && !validdirections.isEmpty(); ++j) {
            Direction direction = (Direction)validdirections.get(random.nextInt(validdirections.size()));
            level.setBlockAndUpdate(pos.relative(direction), WallHibiscusBlock.setPropertiesForDirection(this.getWallHibiscus().defaultBlockState(), direction, random));
            validdirections.remove(direction);
        }
    }
}

