/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.environmental.common.block.CattailStalkBlock;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;

public class CattailBlock
extends BushBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty FLUFFY = BooleanProperty.create((String)"fluffy");
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    public static final IntegerProperty CATTAILS = IntegerProperty.create((String)"cattails", (int)1, (int)3);

    public CattailBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CATTAILS, (Comparable)Integer.valueOf(1))).setValue((Property)TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)FLUFFY, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.getOffset(level, pos);
        return SHAPE.move(vec3d.x, vec3d.y, vec3d.z);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.mayPlaceOn(world.getBlockState(pos.below()), (BlockGetter)world, pos);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(EnvironmentalBlockTags.CATTAIL_PLANTABLE_ON) || state.is((Block)this) || state.is((Block)EnvironmentalBlocks.CATTAIL_STALK.get());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        BlockState belowState = level.getBlockState(pos.below());
        FluidState fluidState = level.getFluidState(pos);
        if (state.is((Block)this)) {
            return (BlockState)state.cycle((Property)CATTAILS);
        }
        if (belowState.is((Block)this) && (Integer)belowState.getValue((Property)CATTAILS) > 1) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)TOP, (Comparable)Boolean.valueOf(belowState.is((Block)this)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue((Property)AGE, (Comparable)Integer.valueOf(level.getRandom().nextInt(this.getMaxAge())));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && context.getItemInHand().getItem() == this.asItem() && (Integer)state.getValue((Property)CATTAILS) < 3 && (Boolean)state.getValue((Property)TOP) == false || super.canBeReplaced(state, context);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CATTAILS, TOP, FLUFFY, WATERLOGGED, AGE});
    }

    protected boolean canGrowInto(BlockState state) {
        return state.is(Blocks.WATER) || state.isAir();
    }

    public int getMaxAge() {
        return 2;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < this.getMaxAge() || (Boolean)state.getValue((Property)WATERLOGGED) != false || (Boolean)state.getValue((Property)FLUFFY) == false && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean notMaxAge;
        if (!((Boolean)state.getValue((Property)FLUFFY)).booleanValue() && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextDouble() < 0.1 ? 1 : 0) != 0)) {
            int i = 1;
            while (this.isCattail(level, pos.below(i)) || this.canGrowFluff(level, pos.below(i))) {
                if (this.canGrowFluff(level, pos.below(i))) {
                    BlockState fluffyState = (BlockState)state.setValue((Property)FLUFFY, (Comparable)Boolean.valueOf(true));
                    level.setBlock(pos, fluffyState, 2);
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)fluffyState));
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    break;
                }
                ++i;
            }
        }
        BlockPos abovePos = pos.above();
        boolean bl = notMaxAge = (Integer)state.getValue((Property)AGE) < this.getMaxAge();
        if ((notMaxAge || ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) && CommonHooks.canCropGrow((Level)level, (BlockPos)abovePos, (BlockState)level.getBlockState(abovePos), (random.nextDouble() < 0.1 ? 1 : 0) != 0) && this.canGrowInto(level.getBlockState(abovePos))) {
            BlockState newState = (BlockState)((BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(abovePos).getType() == Fluids.WATER));
            if (notMaxAge) {
                newState = (BlockState)newState.cycle((Property)AGE);
            }
            level.setBlockAndUpdate(abovePos, newState);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)abovePos, (BlockState)level.getBlockState(abovePos));
        }
    }

    public boolean isCattail(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.is((Block)this) || state.is((Block)EnvironmentalBlocks.CATTAIL_STALK.get());
    }

    public boolean canGrowFluff(ServerLevel level, BlockPos pos) {
        return level.getBlockState(pos).is(Blocks.MUD);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        boolean fluffy = (Boolean)state.getValue((Property)FLUFFY);
        if (!fluffy && stack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (fluffy && stack.canPerformAction(ItemAbilities.SHEARS_CARVE)) {
            if (!level.isClientSide()) {
                level.playSound(null, pos, (SoundEvent)EnvironmentalSoundEvents.CATTAIL_HARVEST.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                if (level.random.nextInt(900) < 5) {
                    level.playSound(null, pos, (SoundEvent)EnvironmentalSoundEvents.CATTAIL_MEOW.get(), SoundSource.BLOCKS, 2.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.2f + 1.0f);
                }
                CattailBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get(), 1 + level.random.nextInt(((Integer)state.getValue((Property)CATTAILS)).intValue())));
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FLUFFY, (Comparable)Boolean.valueOf(false)));
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
                player.awardStat(Stats.ITEM_USED.get((Object)Items.SHEARS));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            RandomSource random = level.getRandom();
            if (((Boolean)state.getValue((Property)FLUFFY)).booleanValue()) {
                Vec3 offset = state.getOffset((BlockGetter)level, pos);
                double offsetX = MathUtil.makeNegativeRandomly((double)(random.nextFloat() * 0.25f), (RandomSource)random);
                double offsetZ = MathUtil.makeNegativeRandomly((double)(random.nextFloat() * 0.25f), (RandomSource)random);
                double x = (double)pos.getX() + offset.x() + 0.5 + offsetX;
                double y = (double)pos.getY() + offset.y() + 0.75 + MathUtil.makeNegativeRandomly((double)(random.nextFloat() * 0.05f), (RandomSource)random);
                double z = (double)pos.getZ() + offset.z() + 0.5 + offsetZ;
                if (random.nextInt(6 - (Integer)state.getValue((Property)CATTAILS)) == 0) {
                    level.addParticle((ParticleOptions)EnvironmentalParticleTypes.CATTAIL_FLUFF.get(), x, y, z, random.nextDouble() * 0.01 * Math.abs(offsetX) / offsetX, 0.0, random.nextDouble() * 0.01 * Math.abs(offsetZ) / offsetZ);
                }
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return this.canGrowInto(level.getBlockState(pos.above())) || (Boolean)state.getValue((Property)FLUFFY) == false && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.above();
        if (!((Boolean)state.getValue((Property)FLUFFY)).booleanValue() && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)FLUFFY, (Comparable)Boolean.valueOf(true)), 2);
        } else if (this.canGrowInto(level.getBlockState(abovePos))) {
            int age = Math.min((Integer)state.getValue((Property)AGE) + 1, this.getMaxAge());
            level.setBlockAndUpdate(abovePos, (BlockState)((BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age))).setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(abovePos).getType() == Fluids.WATER)));
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        if (direction != Direction.UP || !facingState.is((Block)this) && !facingState.is((Block)EnvironmentalBlocks.CATTAIL_STALK.get())) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            }
            return super.updateShape(state, direction, facingState, level, pos, facingPos);
        }
        return (BlockState)BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)((Block)EnvironmentalBlocks.CATTAIL_STALK.get()).defaultBlockState()).setValue((Property)CattailStalkBlock.BOTTOM, (Comparable)Boolean.valueOf(!level.getBlockState(pos.below()).is((Block)EnvironmentalBlocks.CATTAIL_STALK.get())));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)FLUFFY)).booleanValue()) {
            Vec3 offset = state.getOffset((BlockGetter)level, pos);
            double offsetX = MathUtil.makeNegativeRandomly((double)(random.nextFloat() * 0.25f), (RandomSource)random);
            double offsetZ = MathUtil.makeNegativeRandomly((double)(random.nextFloat() * 0.25f), (RandomSource)random);
            double x = (double)pos.getX() + offset.x() + 0.5 + offsetX;
            double y = (double)pos.getY() + offset.y() + 0.75 + MathUtil.makeNegativeRandomly((double)(random.nextFloat() * 0.05f), (RandomSource)random);
            double z = (double)pos.getZ() + offset.z() + 0.5 + offsetZ;
            if (random.nextInt(15) == 0) {
                level.addParticle((ParticleOptions)EnvironmentalParticleTypes.CATTAIL_FLUFF.get(), x, y, z, random.nextDouble() * 0.01 * Math.abs(offsetX) / offsetX, 0.0, random.nextDouble() * 0.01 * Math.abs(offsetZ) / offsetZ);
            }
        }
    }
}

