/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.teamabnormals.environmental.common.block.HangingLeavesBlock;
import com.teamabnormals.environmental.common.block.WisteriaLeafColorBlock;
import com.teamabnormals.environmental.common.levelgen.util.WisteriaColor;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;

public class HangingWisteriaLeavesBlock
extends HangingLeavesBlock
implements IShearable,
WisteriaLeafColorBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    protected static final VoxelShape TOP_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private final WisteriaColor color;

    public HangingWisteriaLeavesBlock(BlockBehaviour.Properties properties, WisteriaColor color) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? TOP_SHAPE : SHAPE;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.above()) == this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER) && !level.isWaterAt(pos) || super.canSurvive(state, level, pos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean moving) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER && !level.getBlockState(pos.below()).is((Block)this)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        if (level.getBlockState((pos = context.getClickedPos()).above()) == this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER) && !level.isWaterAt(pos)) {
            level.setBlock(pos.above(), (BlockState)level.getBlockState(pos.above()).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        }
        return super.getStateForPlacement(context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF});
    }

    @Override
    public WisteriaColor getColor() {
        return this.color;
    }
}

