/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LotusFlowerBlock
extends FlowerBlock {
    private final Supplier<ParticleOptions> particle;

    public LotusFlowerBlock(Supplier<ParticleOptions> particle, Holder<MobEffect> stewEffect, int stewEffectDuration, BlockBehaviour.Properties properties) {
        super(stewEffect, (float)stewEffectDuration, properties);
        this.particle = particle;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (level.isClientSide()) {
            for (int i = 0; i < 3; ++i) {
                double x = (double)pos.getX() + 0.25 + (double)(rand.nextFloat() * 0.6f);
                double y = (double)pos.getY() + 0.25 + (double)(rand.nextFloat() * 0.05f);
                double z = (double)pos.getZ() + 0.25 + (double)(rand.nextFloat() * 0.45f);
                if (level.getGameTime() % 9L != 0L) continue;
                level.addParticle(this.particle.get(), x, y, z, 0.03, 0.0, 0.03);
            }
        }
    }
}

