/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PineconeBlock
extends FallingBlock
implements BonemealableBlock {
    public PineconeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return null;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (PineconeBlock.canFall(level, pos) && pos.getY() >= level.getMinBuildHeight()) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state);
            this.falling(fallingblockentity);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (stack.is(Items.HONEYCOMB)) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            BlockState newState = ((Block)EnvironmentalBlocks.WAXED_PINECONE.get()).defaultBlockState();
            level.setBlock(pos, newState, 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            level.levelEvent(player, 3003, pos, 0);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(3) != 0) {
            BlockState sapling = ((Block)EnvironmentalBlocks.PINE_SAPLING.get()).defaultBlockState();
            ArrayList list = Lists.newArrayList();
            PineconeBlock.addPossibleSaplingPositionsFromNeighbors(4, 4, 4, list, level, pos.offset(-4, -4, -4), new BlockPos.MutableBlockPos(), new boolean[9][9][9]);
            for (int i = 0; i < 12 && !list.isEmpty(); ++i) {
                BlockPos blockpos = (BlockPos)list.remove(random.nextInt(list.size()));
                if (!level.isAreaLoaded(blockpos, 1) || level.getMaxLocalRawBrightness(blockpos.above()) < 9 || !PineconeBlock.hasSpaceForTree(blockpos, level, false)) continue;
                level.setBlockAndUpdate(blockpos, sapling);
                this.spawnBoneMealParticles(level, this.defaultBlockState(), pos);
                this.spawnBoneMealParticles(level, sapling, blockpos);
                return;
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
    }

    public static boolean canFall(ServerLevel level, BlockPos pos) {
        return !PineconeBlock.supportedFromAbove(level, pos) && PineconeBlock.isFree((BlockState)level.getBlockState(pos.below()));
    }

    public static boolean supportedFromAbove(ServerLevel level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.above());
        return Block.isFaceFull((VoxelShape)blockstate.getCollisionShape((BlockGetter)level, pos.above()), (Direction)Direction.DOWN) && !(blockstate.getBlock() instanceof FallingBlock);
    }

    public boolean isValidBonemealTarget(LevelReader p_50897_, BlockPos p_50898_, BlockState p_50899_) {
        return true;
    }

    public boolean isBonemealSuccess(Level p_220878_, RandomSource random, BlockPos p_220880_, BlockState p_220881_) {
        return random.nextInt(3) != 0;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState sapling = ((Block)EnvironmentalBlocks.PINE_SAPLING.get()).defaultBlockState();
        ArrayList list = Lists.newArrayList();
        PineconeBlock.addPossibleSaplingPositionsFromNeighbors(4, 4, 4, list, level, pos.offset(-4, -4, -4), new BlockPos.MutableBlockPos(), new boolean[9][9][9]);
        for (int i = 0; i < 12 && !list.isEmpty(); ++i) {
            BlockPos blockpos = (BlockPos)list.remove(random.nextInt(list.size()));
            if (!level.isAreaLoaded(blockpos, 1) || !PineconeBlock.hasSpaceForTree(blockpos, level, true)) continue;
            level.setBlockAndUpdate(blockpos, sapling);
            this.spawnBoneMealParticles(level, sapling, blockpos);
            return;
        }
    }

    private void spawnBoneMealParticles(ServerLevel level, BlockState state, BlockPos pos) {
        double d1;
        int amount = 15;
        double d0 = 0.5;
        if (state.is((Block)EnvironmentalBlocks.PINECONE.get())) {
            amount *= 2;
            d0 = 4.0;
            d1 = 1.5;
        } else if (state.isSolidRender((BlockGetter)level, pos)) {
            pos = pos.above();
            amount *= 3;
            d0 = 3.0;
            d1 = 1.0;
        } else {
            d1 = state.getShape((BlockGetter)level, pos).max(Direction.Axis.Y);
        }
        level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        RandomSource random = level.getRandom();
        for (int i = 0; i < amount; ++i) {
            double d2 = random.nextGaussian() * 0.02;
            double d3 = random.nextGaussian() * 0.02;
            double d4 = random.nextGaussian() * 0.02;
            double d5 = 0.5 - d0;
            double d6 = (double)pos.getX() + d5 + random.nextDouble() * d0 * 2.0;
            double d7 = (double)pos.getY() + random.nextDouble() * d1;
            double d8 = (double)pos.getZ() + d5 + random.nextDouble() * d0 * 2.0;
            level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, d6, d7, d8, 0, d2, d3, d4, 0.0);
        }
    }

    private static void addPossibleSaplingPositions(int x, int y, int z, List<BlockPos> list, ServerLevel level, BlockPos origin, BlockPos.MutableBlockPos mutablepos, boolean[][][] foundpositions) {
        if (x < 0 || x >= 9 || y < 0 || y >= 9 || z < 0 || z >= 9) {
            return;
        }
        if (foundpositions[x][y][z]) {
            return;
        }
        mutablepos.setWithOffset((Vec3i)origin, x, y, z);
        foundpositions[x][y][z] = true;
        if (level.getBlockState((BlockPos)mutablepos).is(BlockTags.DIRT)) {
            if (level.isEmptyBlock((BlockPos)mutablepos.move(Direction.UP))) {
                list.add(mutablepos.immutable());
            }
            PineconeBlock.addPossibleSaplingPositionsFromNeighbors(x, y, z, list, level, origin, mutablepos, foundpositions);
        }
    }

    private static void addPossibleSaplingPositionsFromNeighbors(int x, int y, int z, List<BlockPos> list, ServerLevel level, BlockPos origin, BlockPos.MutableBlockPos mutablepos, boolean[][][] foundpositions) {
        PineconeBlock.addPossibleSaplingPositions(x - 1, y, z, list, level, origin, mutablepos, foundpositions);
        PineconeBlock.addPossibleSaplingPositions(x + 1, y, z, list, level, origin, mutablepos, foundpositions);
        PineconeBlock.addPossibleSaplingPositions(x, y - 1, z, list, level, origin, mutablepos, foundpositions);
        PineconeBlock.addPossibleSaplingPositions(x, y + 1, z, list, level, origin, mutablepos, foundpositions);
        PineconeBlock.addPossibleSaplingPositions(x, y, z - 1, list, level, origin, mutablepos, foundpositions);
        PineconeBlock.addPossibleSaplingPositions(x, y, z + 1, list, level, origin, mutablepos, foundpositions);
    }

    private static boolean hasSpaceForTree(BlockPos pos, ServerLevel level, boolean bonemeal) {
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        for (int y = -2; y <= 3; ++y) {
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    mutablepos.setWithOffset((Vec3i)pos, x, y, z);
                    if ((y <= 0 || TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)mutablepos) || bonemeal) && !level.getBlockState((BlockPos)mutablepos).is(BlockTags.SAPLINGS)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

