/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PlumLeavesBlock
extends LeavesBlock {
    public PlumLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        float rate;
        super.animateTick(state, level, pos, random);
        double d0 = random.nextGaussian() * 0.02;
        double d1 = random.nextGaussian() * 0.02;
        double d2 = random.nextGaussian() * 0.02;
        float f = level.isThundering() ? 0.2f : (rate = level.isRaining() ? 0.05f : 0.025f);
        if (random.nextFloat() < rate && level.isEmptyBlock(blockpos = pos.below())) {
            double d3 = (float)pos.getX() + random.nextFloat();
            double d4 = (double)pos.getY() - 0.05;
            double d6 = (float)pos.getZ() + random.nextFloat();
            level.addParticle(state.is((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAVES.get()) ? (ParticleOptions)EnvironmentalParticleTypes.CHEERFUL_PLUM_BLOSSOM.get() : (state.is((Block)EnvironmentalBlocks.MOODY_PLUM_LEAVES.get()) ? (ParticleOptions)EnvironmentalParticleTypes.MOODY_PLUM_BLOSSOM.get() : (ParticleOptions)EnvironmentalParticleTypes.PLUM_BLOSSOM.get()), d3, d4, d6, d0, d1, d2);
        }
    }
}

