/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.teamabnormals.environmental.common.block.RedstoneDwarfSpruceHeadBlock;
import com.teamabnormals.environmental.common.block.RedstoneDwarfSprucePlantBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public interface RedstoneDwarfSpruceBlock {
    default public void updateStateNeighborChange(Level level, BlockState state, BlockPos pos) {
        if (!level.isClientSide) {
            boolean lit;
            boolean powered = level.hasNeighborSignal(pos);
            boolean bl = lit = powered || RedstoneDwarfSpruceBlock.isTreePowered(level, pos);
            if (!((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue() && powered) {
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)), 2);
            } else if ((Boolean)state.getValue((Property)BlockStateProperties.LIT) != lit || (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != powered) {
                level.scheduleTick(pos, (Block)this, 4);
            }
        }
    }

    default public void updateStateTick(Level level, BlockState state, BlockPos pos) {
        boolean lit;
        boolean powered = level.hasNeighborSignal(pos);
        boolean bl = lit = powered || RedstoneDwarfSpruceBlock.isTreePowered(level, pos);
        if ((Boolean)state.getValue((Property)BlockStateProperties.LIT) != lit || (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != powered) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(lit))).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    public static BlockState setLitPoweredState(BlockState state, Level level, BlockPos pos) {
        boolean powered = level.hasNeighborSignal(pos);
        boolean lit = powered || RedstoneDwarfSpruceBlock.isTreePowered(level, pos);
        return (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(lit))).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered));
    }

    private static boolean isTreePowered(Level level, BlockPos pos) {
        return RedstoneDwarfSpruceBlock.isTreePowered(level, pos, Direction.DOWN) || RedstoneDwarfSpruceBlock.isTreePowered(level, pos, Direction.UP);
    }

    private static boolean isTreePowered(Level level, BlockPos pos, Direction direction) {
        BlockState blockstate;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        do {
            mutable.move(direction);
            blockstate = level.getBlockState((BlockPos)mutable);
            if ((blockstate.getBlock() instanceof RedstoneDwarfSpruceHeadBlock || blockstate.getBlock() instanceof RedstoneDwarfSprucePlantBlock) && ((Boolean)blockstate.getValue((Property)BlockStateProperties.LIT)).booleanValue()) continue;
            return false;
        } while (!((Boolean)blockstate.getValue((Property)BlockStateProperties.POWERED)).booleanValue());
        return true;
    }
}

