/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.brain.yak;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import com.teamabnormals.environmental.core.registry.EnvironmentalMemoryModuleTypes;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.neoforged.neoforge.event.EventHooks;

public class YakGrazeBehavior
extends Behavior<Yak> {
    private static final int GRAZING_TIME = 40;
    private static final Predicate<BlockState> IS_TALL_GRASS = BlockStatePredicate.forBlock((Block)Blocks.SHORT_GRASS);

    public YakGrazeBehavior() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.PATH, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 40);
    }

    public static BehaviorControl<Yak> createGrazeController() {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.present((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get())).apply((Applicative)instance, grazingTicksMemory -> (level, yak, gameTime) -> {
            int grazingTicks = (Integer)instance.get(grazingTicksMemory);
            if (grazingTicks <= 0) {
                grazingTicksMemory.erase();
                yak.getBrain().useDefaultActivity();
                level.broadcastEntityEvent((Entity)yak, (byte)11);
            } else {
                grazingTicksMemory.set((Object)(grazingTicks - 1));
            }
            return true;
        }));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Yak yak) {
        if (yak.getRandom().nextInt(yak.isBaby() ? 50 : 1000) != 0) {
            return false;
        }
        Brain<Yak> brain = yak.getBrain();
        brain.setMemory((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get(), (Object)40);
        return level.getBlockState(yak.blockPosition().below()).is(Blocks.GRASS_BLOCK) || IS_TALL_GRASS.test(level.getBlockState(yak.blockPosition()));
    }

    protected boolean canStillUse(ServerLevel level, Yak yak, long gameTime) {
        return (level.getBlockState(yak.blockPosition().below()).is(Blocks.GRASS_BLOCK) || IS_TALL_GRASS.test(level.getBlockState(yak.blockPosition()))) && yak.getBrain().hasMemoryValue((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get());
    }

    protected void start(ServerLevel level, Yak yak, long gameTime) {
        this.dementia(yak);
        level.broadcastEntityEvent((Entity)yak, (byte)10);
    }

    protected void stop(ServerLevel level, Yak yak, long gameTime) {
        yak.getBrain().eraseMemory((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get());
    }

    protected void tick(ServerLevel level, Yak yak, long gameTime) {
        this.dementia(yak);
        if (!yak.getBrain().isMemoryValue((MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get(), (Object)Mth.positiveCeilDiv((int)4, (int)2))) {
            return;
        }
        BlockPos pos = yak.blockPosition();
        if (IS_TALL_GRASS.test(level.getBlockState(pos))) {
            if (EventHooks.canEntityGrief((Level)level, (Entity)yak)) {
                level.destroyBlock(pos, false);
            }
            yak.ate();
            this.doStop(level, (LivingEntity)yak, gameTime);
            return;
        }
        if (level.getBlockState(pos = pos.below()).is(Blocks.GRASS_BLOCK)) {
            if (EventHooks.canEntityGrief((Level)level, (Entity)yak)) {
                level.levelEvent(2001, pos, Block.getId((BlockState)Blocks.GRASS_BLOCK.defaultBlockState()));
                level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
            }
            yak.ate();
            this.doStop(level, (LivingEntity)yak, gameTime);
        }
    }

    private void dementia(Yak yak) {
        yak.getBrain().eraseMemory(MemoryModuleType.PATH);
        yak.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        yak.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        yak.getNavigation().stop();
    }
}

