/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.brain.yak;

import com.google.common.collect.ImmutableSet;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import com.teamabnormals.environmental.core.registry.EnvironmentalMemoryModuleTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class YakHerdingSensor
extends Sensor<Yak> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_YAKS.get()), (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    protected void doTick(ServerLevel level, Yak yak) {
        yak.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).ifPresent(entities -> {
            List<Yak> nearest = entities.find(entity -> entity.getType() == yak.getType() && yak.distanceToSqr((Entity)entity) < 144.0).map(Yak.class::cast).sorted(Comparator.comparing(arg_0 -> ((Yak)yak).distanceToSqr(arg_0))).toList();
            ArrayList babyYaks = new ArrayList();
            ArrayList adultYaks = new ArrayList();
            nearest.forEach(y -> {
                if (y.isBaby()) {
                    babyYaks.add(y);
                } else {
                    adultYaks.add(y);
                }
            });
            yak.getBrain().setMemory((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_YAKS.get(), nearest);
            yak.getBrain().setMemory((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_ADULT_YAKS.get(), adultYaks);
            yak.getBrain().setMemory((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_BABY_YAKS.get(), babyYaks);
        });
    }
}

