/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal;

import com.teamabnormals.environmental.common.block.DwarfSpruceBlock;
import com.teamabnormals.environmental.common.block.DwarfSpruceHeadBlock;
import com.teamabnormals.environmental.common.block.DwarfSprucePlantBlock;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CatLeapAtDwarfSpruceGoal
extends Goal {
    private final Cat cat;
    private int nextStartTick;
    private int tryTicks;
    private int maxStayTicks;
    private BlockPos targetPos;
    private boolean leaping;

    public CatLeapAtDwarfSpruceGoal(Cat cat) {
        this.cat = cat;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = 200 + this.cat.getRandom().nextInt(200);
        if (!this.cat.isTame() || this.cat.isOrderedToSit() || this.cat.isLying()) {
            return false;
        }
        this.targetPos = this.findNearestTorchPos();
        return this.targetPos != null;
    }

    public boolean canContinueToUse() {
        if (this.tryTicks < -this.maxStayTicks || this.tryTicks > 600) {
            return false;
        }
        return (!this.cat.onGround() && !this.cat.isInFluidType() || !this.leaping) && this.isTorchSpruce((LevelReader)this.cat.level(), this.targetPos);
    }

    public void start() {
        this.moveMobToBlock();
        this.cat.setInSittingPose(false);
        this.tryTicks = 0;
        this.maxStayTicks = this.cat.getRandom().nextInt(this.cat.getRandom().nextInt(1200) + 1200) + 1200;
        this.leaping = false;
    }

    public void tick() {
        block5: {
            double d3;
            double d1;
            block4: {
                double d0 = (double)this.targetPos.getX() + 0.5 - this.cat.getX();
                d1 = (double)this.targetPos.getY() - this.cat.getY();
                double d2 = (double)this.targetPos.getZ() + 0.5 - this.cat.getZ();
                d3 = Math.sqrt(d0 * d0 + d2 * d2);
                if (!this.leaping) break block4;
                if (!this.cat.blockPosition().equals((Object)this.targetPos)) break block5;
                BlockState blockstate = this.cat.level().getBlockState(this.targetPos);
                DwarfSpruceBlock block = (DwarfSpruceBlock)blockstate.getBlock();
                this.cat.level().setBlockAndUpdate(this.targetPos, block.getWithoutTorchesState(blockstate));
                if (block.getTorch() == null) break block5;
                Block.popResource((Level)this.cat.level(), (BlockPos)this.targetPos, (ItemStack)new ItemStack((ItemLike)block.getTorch()));
                break block5;
            }
            int patience = 1;
            if (d3 < 2.0 && this.cat.onGround()) {
                if (Math.abs(d1) <= 2.0) {
                    Vec3 vec3 = this.cat.getDeltaMovement();
                    Vec3 vec31 = new Vec3((double)this.targetPos.getX() + 0.5 - this.cat.getX(), 0.0, (double)this.targetPos.getZ() + 0.5 - this.cat.getZ());
                    if (vec31.lengthSqr() > 1.0E-7) {
                        vec31 = vec31.normalize().scale(0.3).add(vec3.scale(0.2));
                    }
                    double yd = Math.max((double)this.targetPos.getY() + 0.5 - this.cat.getY(), 0.8);
                    this.cat.setDeltaMovement(vec31.x, Math.sqrt(2.0 * this.cat.getAttributeValue(Attributes.GRAVITY) * yd), vec31.z);
                    this.leaping = true;
                    return;
                }
                patience = 3;
            }
            this.cat.getLookControl().setLookAt((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5);
            for (int i = 0; i < patience; ++i) {
                ++this.tryTicks;
                if (this.tryTicks % 40 != 0) continue;
                this.moveMobToBlock();
            }
        }
    }

    private void moveMobToBlock() {
        this.cat.getNavigation().moveTo((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY(), (double)this.targetPos.getZ() + 0.5, 0.6);
    }

    private boolean isTorchSpruce(LevelReader level, BlockPos pos) {
        DwarfSpruceBlock dwarfspruce;
        Block block = level.getBlockState(pos).getBlock();
        return block instanceof DwarfSpruceBlock && (dwarfspruce = (DwarfSpruceBlock)block).getTorch() != null;
    }

    private boolean isSpruceBottom(LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        Block block = blockstate.getBlock();
        return block instanceof DwarfSprucePlantBlock && (Boolean)blockstate.getValue((Property)DwarfSprucePlantBlock.BOTTOM) != false || block instanceof DwarfSpruceHeadBlock && (Boolean)blockstate.getValue((Property)DwarfSpruceHeadBlock.TOP) == false;
    }

    private BlockPos findNearestTorchPos() {
        BlockPos blockpos = this.cat.blockPosition();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int y = 0;
        while (y <= 1) {
            for (int r = 0; r < 6; ++r) {
                int x = 0;
                while (x <= r) {
                    int z;
                    int n = z = x < r && x > -r ? r : 0;
                    while (z <= r) {
                        mutable.setWithOffset((Vec3i)blockpos, x, y, z);
                        if (this.isSpruceBottom((LevelReader)this.cat.level(), (BlockPos)mutable)) {
                            ArrayList<BlockPos> treepositions = new ArrayList<BlockPos>();
                            for (int i = 0; i <= 2; ++i) {
                                mutable.setWithOffset((Vec3i)blockpos, x, y + i, z);
                                if (!this.isTorchSpruce((LevelReader)this.cat.level(), (BlockPos)mutable)) continue;
                                treepositions.add(mutable.immutable());
                            }
                            if (!treepositions.isEmpty()) {
                                return (BlockPos)treepositions.get(this.cat.getRandom().nextInt(treepositions.size()));
                            }
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
        return null;
    }
}

