/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class HerdWanderGoal
extends RandomStrollGoal {
    protected Predicate<PathfinderMob> herdPredicate = this.defaultHerdPredicate();
    protected double speedModifierFar;
    protected int preferredHerdSize;
    protected boolean isHerdFar;

    public HerdWanderGoal(PathfinderMob mob, double speed, double speedFar, int herdSize) {
        super(mob, speed);
        this.speedModifierFar = speedFar;
        this.preferredHerdSize = herdSize;
    }

    public HerdWanderGoal(PathfinderMob mob, double speed, double speedFar, int interval, int herdSize) {
        super(mob, speed, interval);
        this.speedModifierFar = speedFar;
        this.preferredHerdSize = herdSize;
    }

    public HerdWanderGoal(PathfinderMob mob, double speed, double speedFar, int interval, boolean checkNoActionTime, int herdSize) {
        super(mob, speed, interval, checkNoActionTime);
        this.speedModifierFar = speedFar;
        this.preferredHerdSize = herdSize;
    }

    @Nullable
    protected Vec3 getPosition() {
        List herd = this.mob.level().getEntitiesOfClass(PathfinderMob.class, this.mob.getBoundingBox().inflate(32.0, 8.0, 32.0), this.herdPredicate.and(entity -> entity != this.mob));
        List<PathfinderMob> closeherd = herd.stream().sorted(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)this.mob))).limit(this.preferredHerdSize - 1).toList();
        if (!closeherd.isEmpty()) {
            PathfinderMob entity2;
            int herdsize;
            double frienddist = this.mob.distanceToSqr((Entity)closeherd.get(0));
            double herdx = 0.0;
            double herdy = 0.0;
            double herdz = 0.0;
            Iterator<PathfinderMob> iterator = closeherd.iterator();
            for (herdsize = 0; iterator.hasNext() && (!(this.mob.distanceToSqr((Entity)(entity2 = iterator.next())) > 144.0) || herdsize < this.preferredHerdSize - 2); ++herdsize) {
                herdx += entity2.getX();
                herdy += entity2.getY();
                herdz += entity2.getZ();
            }
            Vec3 herdcenter = new Vec3(herdx / (double)herdsize, herdy / (double)herdsize, herdz / (double)herdsize);
            if (herdsize > 0) {
                double herddist = this.mob.distanceToSqr(herdcenter);
                if (frienddist > 9.0 || herddist > 64.0) {
                    int maxdist = Math.min(Math.max(Mth.floor((double)Math.sqrt(herddist)), 3), 16);
                    int mindist = Math.max(maxdist - 4, 1);
                    for (int i = 0; i < 8; ++i) {
                        Vec3 pos = DefaultRandomPos.getPosTowards((PathfinderMob)this.mob, (int)maxdist, (int)mindist, (Vec3)herdcenter, (double)1.5707963267948966);
                        if (pos == null) continue;
                        this.isHerdFar = herddist > 196.0;
                        return pos;
                    }
                }
            }
        }
        return this.randomPosition();
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.isHerdFar ? this.speedModifierFar : this.speedModifier);
    }

    public HerdWanderGoal setHerdPredicate(Predicate<PathfinderMob> predicate) {
        this.herdPredicate = predicate;
        return this;
    }

    protected Predicate<PathfinderMob> defaultHerdPredicate() {
        return entity -> entity.getClass().isAssignableFrom(this.mob.getClass()) || this.mob.getClass().isAssignableFrom(entity.getClass());
    }

    protected Vec3 randomPosition() {
        return DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
    }
}

