/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal;

import com.google.common.collect.Lists;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class HuntTruffleGoal
extends Goal {
    private final Pig pig;
    private final IDataManager data;
    private int runDelay;
    private int lookTimer;
    private Vec3 lookVector;

    public HuntTruffleGoal(Pig pigIn) {
        this.pig = pigIn;
        this.data = (IDataManager)this.pig;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = this.adjustedTickDelay(20);
        if (((Boolean)this.data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET)).booleanValue()) {
            return true;
        }
        return (Integer)this.data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME) > 0 && this.findTruffle();
    }

    public boolean canContinueToUse() {
        return (Boolean)this.data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET) != false && (Integer)this.data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME) != 0;
    }

    public void start() {
        this.lookVector = new Vec3(1.0, 0.0, 1.0);
        this.moveToTruffle();
        this.data.setValue(EnvironmentalDataProcessors.LOOKING_FOR_TRUFFLE, (Object)true);
    }

    public void stop() {
        this.data.setValue(EnvironmentalDataProcessors.LOOKING_FOR_TRUFFLE, (Object)false);
    }

    public void tick() {
        int trufflehuntingtime = (Integer)this.data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME);
        BlockPos blockpos = (BlockPos)this.data.getValue(EnvironmentalDataProcessors.TRUFFLE_POS);
        Vec3 pigpos = this.pig.position();
        Vec3 vector3d = new Vec3((double)blockpos.getX() + 0.5 - pigpos.x(), 0.0, (double)blockpos.getZ() + 0.5 - pigpos.z()).normalize();
        this.pig.getLookControl().setLookAt(pigpos.x() + vector3d.x() * this.lookVector.x(), this.pig.getY() - 0.6 + this.lookVector.y(), pigpos.z() + vector3d.z() * this.lookVector.z(), (float)(this.pig.getMaxHeadYRot() + 20), (float)this.pig.getMaxHeadXRot());
        if (blockpos.closerThan((Vec3i)this.pig.blockPosition(), 4.0)) {
            if (trufflehuntingtime > 0) {
                this.data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)-800);
            }
        } else {
            if (this.lookTimer-- <= 0) {
                this.lookTimer = this.adjustedTickDelay(18 + this.pig.getRandom().nextInt(9));
                this.lookVector = new Vec3((double)this.pig.getRandom().nextFloat() * 1.2, (double)this.pig.getRandom().nextFloat() * 0.4, (double)this.pig.getRandom().nextFloat() * 1.2);
            }
            this.moveToTruffle();
        }
    }

    private void moveToTruffle() {
        BlockPos blockpos = (BlockPos)this.data.getValue(EnvironmentalDataProcessors.TRUFFLE_POS);
        this.pig.getNavigation().moveTo((double)blockpos.getX() + 0.5, (double)(blockpos.getY() + 1), (double)blockpos.getZ() + 0.5, 1.1);
    }

    private boolean findTruffle() {
        if (!this.pig.level().dimensionType().natural()) {
            return false;
        }
        int range = 80;
        int height = 16;
        BlockPos blockpos = this.pig.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        ArrayList truffleblocks = Lists.newArrayList();
        for (int i = 0; i < range; ++i) {
            boolean flag = false;
            for (int y = -height; y < height; ++y) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        blockpos$mutable.setWithOffset((Vec3i)blockpos, x, y - 1, z);
                        if (this.pig.isWithinRestriction((BlockPos)blockpos$mutable)) {
                            if (this.isTruffle(this.pig.level(), (BlockPos)blockpos$mutable)) {
                                this.data.setValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET, (Object)true);
                                this.data.setValue(EnvironmentalDataProcessors.TRUFFLE_POS, (Object)blockpos$mutable);
                                return true;
                            }
                            if (this.isSuitableForTruffle(this.pig.level(), (BlockPos)blockpos$mutable)) {
                                if (i <= 48 && !flag) {
                                    flag = true;
                                    truffleblocks.clear();
                                }
                                truffleblocks.add(blockpos$mutable.immutable());
                            }
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
        }
        if (truffleblocks.size() > 0) {
            BlockPos trufflepos = (BlockPos)truffleblocks.get(this.pig.getRandom().nextInt(truffleblocks.size()));
            this.pig.level().setBlock(trufflepos, ((Block)EnvironmentalBlocks.BURIED_TRUFFLE.get()).defaultBlockState(), 3);
            this.data.setValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET, (Object)true);
            this.data.setValue(EnvironmentalDataProcessors.TRUFFLE_POS, (Object)trufflepos);
            return true;
        }
        return false;
    }

    private boolean isTruffle(Level worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos).getBlock() == EnvironmentalBlocks.BURIED_TRUFFLE.get();
    }

    private boolean isSuitableForTruffle(Level worldIn, BlockPos pos) {
        if (worldIn.getBlockState(pos).getBlock() != Blocks.DIRT) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.getBlockState(pos.relative(direction));
            if (!(direction == Direction.UP ? !blockstate.is(EnvironmentalBlockTags.GRASS_LIKE) && (!blockstate.is(BlockTags.DIRT) || !worldIn.getBlockState(pos.above()).is(EnvironmentalBlockTags.GRASS_LIKE)) : !blockstate.is(BlockTags.DIRT))) continue;
            return false;
        }
        return true;
    }
}

