/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.deer;

import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class DeerAvoidEntityGoal
extends Goal {
    private final AbstractDeer deer;
    private final PathNavigation pathNav;
    @Nullable
    private LivingEntity toAvoid;
    private boolean running;

    public DeerAvoidEntityGoal(AbstractDeer deerIn) {
        this.deer = deerIn;
        this.pathNav = deerIn.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.toAvoid = this.deer.getNearestScaryEntity();
        return this.toAvoid != null;
    }

    public boolean canContinueToUse() {
        LivingEntity entity = this.deer.getNearestScaryEntity();
        if (entity != null && entity != this.toAvoid) {
            this.toAvoid = entity;
            return true;
        }
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(this.toAvoid)) {
            return false;
        }
        if (!this.toAvoid.isAlive()) {
            return false;
        }
        return this.deer.distanceToSqr((Entity)this.toAvoid) <= 256.0;
    }

    public void start() {
        this.running = false;
        this.flee();
    }

    public void stop() {
        this.toAvoid = null;
    }

    public void tick() {
        if (this.pathNav.isDone()) {
            this.flee();
        }
        if (!this.running && this.deer.distanceToSqr((Entity)this.toAvoid) <= 36.0) {
            this.running = true;
            this.deer.getNavigation().setSpeedModifier((double)1.8f);
        }
    }

    private void flee() {
        Vec3 vec3 = DefaultRandomPos.getPosAway((PathfinderMob)this.deer, (int)12, (int)6, (Vec3)this.toAvoid.position());
        if (vec3 != null && this.toAvoid.distanceToSqr(vec3.x, vec3.y, vec3.z) >= this.toAvoid.distanceToSqr((Entity)this.deer)) {
            Path path = this.pathNav.createPath(vec3.x, vec3.y, vec3.z, 0);
            this.pathNav.moveTo(path, this.running ? (double)1.8f : 1.2);
        }
    }
}

