/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.deer;

import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import com.teamabnormals.environmental.common.entity.animal.deer.Reindeer;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class DeerGrazeGoal
extends Goal {
    private final AbstractDeer deer;
    private final Level level;
    private int grazeTime;

    public DeerGrazeGoal(AbstractDeer deerIn) {
        this.deer = deerIn;
        this.level = deerIn.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        return this.deer.getRandom().nextInt(350) == 0 && this.checkState();
    }

    public boolean checkState() {
        BlockPos pos = this.deer.blockPosition();
        boolean reindeer = this.deer instanceof Reindeer;
        if (!reindeer) {
            pos = pos.below();
        }
        return this.level.getBlockState(pos).is(reindeer ? (Block)EnvironmentalBlocks.CUP_LICHEN.get() : Blocks.GRASS_BLOCK);
    }

    public void start() {
        this.grazeTime = this.adjustedTickDelay(40 + this.deer.getRandom().nextInt(100));
        this.deer.setTargetNeckAngle(130);
        this.deer.getNavigation().stop();
    }

    public void stop() {
        this.deer.resetTargetNeckAngle();
    }

    public boolean canContinueToUse() {
        return this.grazeTime > 0 && this.checkState();
    }

    public void tick() {
        --this.grazeTime;
    }
}

