/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.duck;

import com.teamabnormals.environmental.common.entity.animal.Duck;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class DucksInARowGoal
extends Goal {
    public final Duck duck;
    private double speedModifier;
    private int distCheckCounter;

    public DucksInARowGoal(Duck p_25501_, double p_25502_) {
        this.duck = p_25501_;
        this.speedModifier = p_25502_;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.duck.isLeashed() && !this.duck.inRow() && this.duck.isBaby()) {
            List list = this.duck.level().getEntities((Entity)this.duck, this.duck.getBoundingBox().inflate(9.0, 4.0, 9.0), entity -> entity instanceof Duck);
            Duck duck = null;
            double d0 = Double.MAX_VALUE;
            for (Entity entity2 : list) {
                double d1;
                Duck duck1 = (Duck)entity2;
                if (!duck1.inRow() || duck1.hasRow() || (d1 = this.duck.distanceToSqr((Entity)duck1)) > d0) continue;
                d0 = d1;
                duck = duck1;
            }
            if (duck == null) {
                for (Entity entity1 : list) {
                    double d2;
                    Duck duck2 = (Duck)entity1;
                    if (duck2.isBaby() || duck2.hasRow() || (d2 = this.duck.distanceToSqr((Entity)duck2)) > d0) continue;
                    d0 = d2;
                    duck = duck2;
                }
            }
            if (duck == null) {
                return false;
            }
            if (d0 < 0.25) {
                return false;
            }
            if (duck.isBaby() && !this.firstIsAdult(duck, 1)) {
                return false;
            }
            this.duck.joinRow(duck);
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.duck.inRow() && this.duck.getRowHead().isAlive() && this.firstIsAdult(this.duck, 0)) {
            double d0 = this.duck.distanceToSqr((Entity)this.duck.getRowHead());
            if (d0 > 676.0) {
                if (this.speedModifier <= 3.0) {
                    this.speedModifier *= 1.2;
                    this.distCheckCounter = DucksInARowGoal.reducedTickDelay((int)40);
                    return true;
                }
                if (this.distCheckCounter == 0) {
                    return false;
                }
            }
            if (this.distCheckCounter > 0) {
                --this.distCheckCounter;
            }
            return true;
        }
        return false;
    }

    public void stop() {
        this.duck.leaveRow();
        this.speedModifier = 1.1;
    }

    public void tick() {
        if (this.duck.inRow()) {
            Duck duck = this.duck.getRowHead();
            double d0 = this.duck.distanceTo((Entity)duck);
            Vec3 vec3 = new Vec3(duck.getX() - this.duck.getX(), duck.getY() - this.duck.getY(), duck.getZ() - this.duck.getZ()).normalize().scale(Math.max(d0 - 0.25, 0.0));
            this.duck.getNavigation().moveTo(this.duck.getX() + vec3.x, this.duck.getY() + vec3.y, this.duck.getZ() + vec3.z, this.speedModifier);
        }
    }

    private boolean firstIsAdult(Duck duck1, int size) {
        if (size > 8) {
            return false;
        }
        if (duck1.inRow()) {
            if (!duck1.getRowHead().isBaby()) {
                return true;
            }
            Duck duck = duck1.getRowHead();
            return this.firstIsAdult(duck, ++size);
        }
        return false;
    }
}

