/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.pineconegolem;

import com.google.common.collect.Lists;
import com.teamabnormals.environmental.common.entity.animal.PineconeGolem;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.pathfinder.Path;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;

public class PineconeGolemPlantSaplingGoal
extends Goal {
    private final PineconeGolem golem;
    private final double moveSpeed;
    private int nextStartTicks;
    private int tryTicks;
    private int maxStayTicks;
    private boolean canPlant;
    private BlockPos targetPos = BlockPos.ZERO;
    private ItemStack heldItem;
    private BlockState saplingState;

    public PineconeGolemPlantSaplingGoal(PineconeGolem golem, double speed) {
        this.golem = golem;
        this.moveSpeed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        Item item;
        if (this.nextStartTicks > 0) {
            --this.nextStartTicks;
            return false;
        }
        this.nextStartTicks = this.adjustedTickDelay(20);
        if (!EventHooks.canEntityGrief((Level)this.golem.level(), (Entity)this.golem)) {
            return false;
        }
        ItemStack itemstack = this.golem.getMainHandItem();
        if (itemstack.is(ItemTags.SAPLINGS) && (item = itemstack.getItem()) instanceof BlockItem) {
            BlockItem blockitem = (BlockItem)item;
            BlockState blockstate = blockitem.getBlock().defaultBlockState();
            BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
            int y = 0;
            while (y >= -1) {
                ArrayList list = Lists.newArrayList();
                for (int x = -3; x <= 3; ++x) {
                    for (int z = -3; z <= 3; ++z) {
                        list.add(new BlockPos((Vec3i)mutablepos.setWithOffset((Vec3i)this.golem.blockPosition(), x, y, z)));
                    }
                }
                while (!list.isEmpty()) {
                    BlockPos blockpos = (BlockPos)list.remove(this.golem.getRandom().nextInt(list.size()));
                    if (!this.isValidTarget(blockpos, blockstate) || !this.golem.isWithinRestriction(blockpos) || !this.hasSpaceForTree(blockpos) || !this.moveMobToBlock(blockpos)) continue;
                    this.targetPos = blockpos;
                    this.heldItem = itemstack;
                    this.saplingState = blockstate;
                    return true;
                }
                y = y < 0 ? -y : -y - 1;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.tryTicks < -this.maxStayTicks || this.tryTicks > 1200) {
            return false;
        }
        if (this.golem.getMainHandItem() != this.heldItem) {
            return false;
        }
        return this.canPlant && this.isValidTarget(this.targetPos, this.saplingState);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        this.tryTicks = 0;
        this.maxStayTicks = this.golem.getRandom().nextInt(this.golem.getRandom().nextInt(1200) + 1200) + 1200;
        this.canPlant = true;
    }

    public void stop() {
        this.heldItem = null;
        this.saplingState = null;
        this.golem.getNavigation().stop();
    }

    public void tick() {
        if (!this.targetPos.closerToCenterThan((Position)this.golem.position(), 1.25)) {
            ++this.tryTicks;
            if (this.tryTicks % 40 == 0 && !this.moveMobToBlock(this.targetPos)) {
                this.canPlant = false;
            }
        } else {
            if (this.hasSpaceForTree(this.targetPos) && !EventHooks.onBlockPlace((Entity)this.golem, (BlockSnapshot)BlockSnapshot.create((ResourceKey)this.golem.level().dimension(), (LevelAccessor)this.golem.level(), (BlockPos)this.targetPos.below()), (Direction)Direction.UP)) {
                this.golem.level().setBlockAndUpdate(this.targetPos, this.saplingState);
                SoundType soundtype = this.saplingState.getSoundType((LevelReader)this.golem.level(), this.targetPos, (Entity)this.golem);
                this.golem.level().playSound(null, this.targetPos, this.saplingState.getSoundType((LevelReader)this.golem.level(), this.targetPos, (Entity)this.golem).getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                this.golem.level().gameEvent((Holder)GameEvent.BLOCK_PLACE, this.targetPos, GameEvent.Context.of((Entity)this.golem, (BlockState)this.saplingState));
                this.golem.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
            this.canPlant = false;
        }
    }

    private boolean isValidTarget(BlockPos pos, BlockState state) {
        return this.golem.level().isEmptyBlock(pos) && state.canSurvive((LevelReader)this.golem.level(), pos);
    }

    private boolean hasSpaceForTree(BlockPos pos) {
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        for (int y = -2; y <= 6; ++y) {
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    mutablepos.setWithOffset((Vec3i)pos, x, y, z);
                    if ((y <= 0 || TreeFeature.validTreePos((LevelSimulatedReader)this.golem.level(), (BlockPos)mutablepos)) && !this.golem.level().getBlockState((BlockPos)mutablepos).is(BlockTags.SAPLINGS)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean moveMobToBlock(BlockPos pos) {
        Path path = this.golem.getNavigation().createPath((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0);
        if (path != null && path.canReach()) {
            this.golem.getNavigation().moveTo(path, this.moveSpeed);
            return true;
        }
        return false;
    }
}

