/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.slabfish;

import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class SlabbyFollowParentGoal
extends Goal {
    private final Slabfish childAnimal;
    private Slabfish parentAnimal;
    private final double moveSpeed;
    private int delayCounter;

    public SlabbyFollowParentGoal(Slabfish animal, double speed) {
        this.childAnimal = animal;
        this.moveSpeed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.childAnimal.getAge() >= 0) {
            return false;
        }
        if (this.childAnimal.isOrderedToSit()) {
            return false;
        }
        List list = this.childAnimal.level().getEntitiesOfClass(((Object)((Object)this.childAnimal)).getClass(), this.childAnimal.getBoundingBox().inflate(8.0, 4.0, 8.0));
        Slabfish slabfish = null;
        double d0 = Double.MAX_VALUE;
        for (Slabfish slabfish1 : list) {
            double d1;
            if (slabfish1.getAge() < 0 || (d1 = this.childAnimal.distanceToSqr((Entity)slabfish1)) > d0) continue;
            d0 = d1;
            slabfish = slabfish1;
        }
        if (slabfish == null) {
            return false;
        }
        if (d0 < 9.0) {
            return false;
        }
        this.parentAnimal = slabfish;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.childAnimal.getAge() >= 0) {
            return false;
        }
        if (!this.parentAnimal.isAlive()) {
            return false;
        }
        double d0 = this.childAnimal.distanceToSqr((Entity)this.parentAnimal);
        return !(d0 < 9.0) && !(d0 > 256.0);
    }

    public void start() {
        this.delayCounter = 0;
    }

    public void stop() {
        this.parentAnimal = null;
    }

    public void tick() {
        if (--this.delayCounter <= 0) {
            this.delayCounter = this.adjustedTickDelay(10);
            this.childAnimal.getNavigation().moveTo((Entity)this.parentAnimal, this.moveSpeed);
        }
    }
}

