/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.tapir;

import com.teamabnormals.environmental.common.entity.animal.Tapir;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class TapirTemptGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.forNonCombat().range(10.0).ignoreLineOfSight();
    private final TargetingConditions targetingConditions;
    protected final Tapir tapir;
    private final double speedModifier;
    @Nullable
    protected Player player;
    private int calmDown;

    public TapirTemptGoal(Tapir tapir, double speed) {
        this.tapir = tapir;
        this.speedModifier = speed;
        this.targetingConditions = TEMP_TARGETING.copy().selector(this::shouldFollow);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.player = this.tapir.level().getNearestPlayer(this.targetingConditions, (LivingEntity)this.tapir);
        return this.player != null;
    }

    private boolean shouldFollow(LivingEntity entity) {
        return (this.tapir.isFood(entity.getMainHandItem()) || this.tapir.isFood(entity.getOffhandItem())) && !this.tapir.hasFloraItem();
    }

    public void start() {
        this.tapir.setBeingTempted(true);
    }

    public void stop() {
        this.player = null;
        this.tapir.getNavigation().stop();
        this.tapir.setBeingTempted(false);
        this.calmDown = TapirTemptGoal.reducedTickDelay((int)100);
    }

    public void tick() {
        this.tapir.getLookControl().setLookAt((Entity)this.player, (float)(this.tapir.getMaxHeadYRot() + 20), (float)this.tapir.getMaxHeadXRot());
        if (this.tapir.distanceToSqr((Entity)this.player) < 6.25) {
            this.tapir.getNavigation().stop();
        } else {
            this.tapir.getNavigation().moveTo((Entity)this.player, this.speedModifier);
        }
    }
}

