/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.zebroid;

import com.teamabnormals.environmental.common.entity.animal.zebroid.Zebroid;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.pathfinder.Path;

public class ZebroidAttackGoal<Z extends AbstractHorse>
extends MeleeAttackGoal {
    public ZebroidAttackGoal(Z zebroid, double speed) {
        super(zebroid, speed, true);
    }

    public boolean canUse() {
        return super.canUse() && !this.mob.hasPassenger((Entity)this.mob.getTarget());
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && !this.mob.hasPassenger((Entity)this.mob.getTarget());
    }

    public void tick() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null) {
            this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            double d0 = this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.getX();
                this.pathedTargetY = livingentity.getY();
                this.pathedTargetZ = livingentity.getZ();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                Path path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
                if (!this.mob.getNavigation().moveTo(path, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingentity);
        }
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.isTimeToAttack() && this.mob.getBoundingBox().inflate(1.0).intersects(target.getBoundingBox())) {
            this.resetAttackCooldown();
            double x = target.getX() - this.mob.getX();
            double y = target.getZ() - this.mob.getZ();
            float f = (float)(Mth.atan2((double)y, (double)x) * 57.2957763671875) - 90.0f;
            this.mob.setYRot(f);
            this.mob.yRotO = this.mob.getYRot();
            this.mob.yHeadRot = this.mob.yBodyRot = this.mob.getYRot();
            ((Zebroid)this.mob).kick(false);
            ((Zebroid)this.mob).playKickingSound();
        }
    }
}

