/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal;

import com.teamabnormals.blueprint.core.api.EggLayer;
import com.teamabnormals.environmental.common.entity.ai.goal.duck.DuckAvoidEntityGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.duck.DuckSwimGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.duck.DucksInARowGoal;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class Duck
extends Animal
implements EggLayer {
    private static final EntityDataAccessor<Integer> EATING = SynchedEntityData.defineId(Duck.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private float wingRotation;
    private float destPos;
    private float oFlapSpeed;
    private float oFlap;
    private float wingRotDelta = 1.0f;
    private float headLean;
    private float prevHeadLean;
    public int timeUntilNextEgg = this.random.nextInt(6000) + 6000;
    public boolean duckJockey;
    @Nullable
    private Duck rowHead;
    @Nullable
    private Duck rowTail;
    private static final Predicate<Entity> AVOID_PLAYERS = entity -> !entity.isDiscrete() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity);

    public Duck(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.goalSelector.addGoal(2, (Goal)new DucksInARowGoal(this, 1.1));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(EnvironmentalItemTags.DUCK_FOOD), false));
        this.goalSelector.addGoal(5, new DuckAvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 2.0f, 1.0, 1.0, AVOID_PLAYERS::test));
        this.goalSelector.addGoal(6, (Goal)new DuckSwimGoal(this));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(EATING, (Object)0);
    }

    public double getFluidJumpThreshold() {
        return this.isBaby() ? 0.2 : 0.4;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public void leaveRow() {
        if (this.rowHead != null) {
            this.rowHead.rowTail = null;
        }
        this.rowHead = null;
    }

    public void joinRow(Duck p_30767_) {
        this.rowHead = p_30767_;
        this.rowHead.rowTail = this;
    }

    public boolean hasRow() {
        return this.rowTail != null;
    }

    public boolean inRow() {
        return this.rowHead != null;
    }

    @Nullable
    public Duck getRowHead() {
        return this.rowHead;
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide() && this.isDeadOrDying()) {
            this.leaveRow();
        }
        super.remove(reason);
    }

    public void aiStep() {
        super.aiStep();
        double d0 = this.getFluidHeight(FluidTags.WATER);
        boolean flag = !this.isBaby() && d0 > 0.3 || this.isBaby() && d0 > 0.15;
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.onGround() || this.wasTouchingWater ? -1 : 4) * 0.3);
        this.destPos = Mth.clamp((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.onGround() && !flag && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        this.wingRotation += this.wingRotDelta * 2.0f;
        this.prevHeadLean = this.headLean;
        if (this.isEating()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        Vec3 vector3d = this.getDeltaMovement();
        if (!this.onGround() && vector3d.y < 0.0) {
            this.setDeltaMovement(vector3d.multiply(1.0, 0.6, 1.0));
        }
        if (!this.level().isClientSide) {
            if (this.isAlive() && !this.isBaby() && !this.wasTouchingWater && !this.isBirdJockey() && --this.timeUntilNextEgg <= 0) {
                this.playSound(this.getEggLayingSound(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.spawnAtLocation((ItemLike)this.getEggItem());
                this.timeUntilNextEgg = this.getNextEggTime(this.random);
            }
            if (this.isEating()) {
                if (this.wasTouchingWater && !this.isInLove()) {
                    this.setEatingTime(this.getEatingTime() - 1);
                } else {
                    this.setEatingTime(0);
                }
            } else if (!this.isInLove() && this.random.nextInt(300) == 0 && this.wasTouchingWater) {
                this.setEatingTime(40 + this.random.nextInt(20));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getWingRotation(float partialTicks) {
        float f = Mth.lerp((float)partialTicks, (float)this.oFlap, (float)this.wingRotation);
        float f1 = Mth.lerp((float)partialTicks, (float)this.oFlapSpeed, (float)this.destPos);
        return (Mth.sin((float)f) + 1.0f) * f1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadLean(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevHeadLean, (float)this.headLean);
    }

    public boolean isEating() {
        return this.getEatingTime() > 0;
    }

    public int getEatingTime() {
        return (Integer)this.entityData.get(EATING);
    }

    public void setEatingTime(int eatingTimeIn) {
        this.entityData.set(EATING, (Object)eatingTimeIn);
    }

    public static boolean checkDuckSpawnRules(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.getBlockState(pos.below()).is(EnvironmentalBlockTags.WATER_ANIMALS_SPAWNABLE_ON) && Duck.isBrightEnoughToSpawn((BlockAndTintGetter)worldIn, (BlockPos)pos);
    }

    protected float getWaterSlowDown() {
        return 0.9f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)EnvironmentalSoundEvents.DUCK_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.DUCK_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EnvironmentalSoundEvents.DUCK_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)EnvironmentalSoundEvents.DUCK_STEP.get(), 0.15f, 1.0f);
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of(EnvironmentalItemTags.DUCK_FOOD).test(stack);
    }

    public int getBaseExperienceReward() {
        return this.isBirdJockey() ? 10 : super.getBaseExperienceReward();
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.duckJockey = compound.getBoolean("IsDuckJockey");
        if (compound.contains("EggLayTime")) {
            this.timeUntilNextEgg = compound.getInt("EggLayTime");
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("IsDuckJockey", this.duckJockey);
        compound.putInt("EggLayTime", this.timeUntilNextEgg);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return this.isBirdJockey();
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        if (passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            living.yBodyRot = this.yBodyRot;
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)EnvironmentalEntityTypes.DUCK.get()).create((Level)world);
    }

    public int getEggTimer() {
        return this.timeUntilNextEgg;
    }

    public void setEggTimer(int time) {
        this.timeUntilNextEgg = time;
    }

    public boolean isBirdJockey() {
        return this.duckJockey;
    }

    public void setBirdJockey(boolean jockey) {
        this.duckJockey = jockey;
    }

    public Item getEggItem() {
        return (Item)EnvironmentalItems.DUCK_EGG.get();
    }

    public int getNextEggTime(RandomSource rand) {
        return rand.nextInt(6000) + 6000;
    }

    public SoundEvent getEggLayingSound() {
        return (SoundEvent)EnvironmentalSoundEvents.DUCK_EGG.get();
    }
}

