/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal;

import com.teamabnormals.environmental.common.entity.ai.goal.pineconegolem.PineconeGolemGrabSaplingGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.pineconegolem.PineconeGolemLookForSpotGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.pineconegolem.PineconeGolemPlantSaplingGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.pineconegolem.PineconeGolemTemptGoal;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PineconeGolem
extends AbstractGolem {
    public PineconeGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.setCanPickUpLoot(true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PineconeGolemTemptGoal(this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new PineconeGolemPlantSaplingGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new PineconeGolemLookForSpotGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new PineconeGolemGrabSaplingGoal(this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.125);
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)EnvironmentalSoundEvents.PINECONE_GOLEM_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EnvironmentalSoundEvents.PINECONE_GOLEM_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)EnvironmentalSoundEvents.PINECONE_GOLEM_STEP.get(), 0.1f, 1.0f);
    }

    public int getMaxHeadXRot() {
        return 0;
    }

    public int getMaxHeadYRot() {
        return 5;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack stack1 = this.getMainHandItem();
        if (stack1.isEmpty()) {
            if (stack.is(ItemTags.SAPLINGS)) {
                ItemStack stack2 = stack.copy();
                stack2.setCount(1);
                this.setItemInHand(InteractionHand.MAIN_HAND, stack2);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (hand == InteractionHand.MAIN_HAND && stack.isEmpty()) {
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            player.addItem(stack1);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void knockback(double force, double x, double z) {
        super.knockback(force, x, z);
        ItemStack itemstack = this.getMainHandItem();
        if (!itemstack.isEmpty()) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemstack);
            itementity.setPickUpDelay(40);
            itementity.setThrower((Entity)this);
            this.level().addFreshEntity((Entity)itementity);
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
    }

    protected void updateWalkAnimation(float p_268283_) {
        float f = Math.min(p_268283_ * 16.0f, 1.0f);
        this.walkAnimation.update(f, 0.4f);
    }

    public boolean canHoldItem(ItemStack stack) {
        return this.getMainHandItem().isEmpty() && stack.is(ItemTags.SAPLINGS);
    }

    protected void pickUpItem(ItemEntity itementity) {
        ItemStack itemstack = itementity.getItem();
        if (this.canHoldItem(itemstack)) {
            int i = itemstack.getCount();
            if (i > 1) {
                ItemEntity itementity1 = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemstack.split(i - 1));
                this.level().addFreshEntity((Entity)itementity1);
            }
            this.onItemPickup(itementity);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
            this.take((Entity)itementity, itemstack.getCount());
            itementity.discard();
        }
    }
}

