/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal;

import com.teamabnormals.environmental.common.entity.ai.goal.tapir.TapirHuntFloraGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.tapir.TapirPanicGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.tapir.TapirSniffForFloraGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.tapir.TapirTemptGoal;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Tapir
extends Animal {
    private static final EntityDataAccessor<Integer> TRACKING_TIME = SynchedEntityData.defineId(Tapir.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> HAS_BABY_PATTERN = SynchedEntityData.defineId(Tapir.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BEING_TEMPTED = SynchedEntityData.defineId(Tapir.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SNIFFING = SynchedEntityData.defineId(Tapir.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_GRAZING = SynchedEntityData.defineId(Tapir.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<BlockPos>> FLORA_POS = SynchedEntityData.defineId(Tapir.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private Item floraItem;
    private boolean running;
    private int sniffTimer;
    private float sniffAmount;
    private float sniffAmount0;
    private float snoutRaiseAmount;
    private float snoutRaiseAmount0;
    private float noAnimAmount;
    private float noAnimAmount0;
    private float neckAngle;
    private float neckAngle0;
    private int headShakeAnim;
    private int headShakeAnim0;

    public Tapir(EntityType<? extends Tapir> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TapirPanicGoal(this));
        this.goalSelector.addGoal(2, (Goal)new TapirSniffForFloraGoal(this));
        this.goalSelector.addGoal(3, (Goal)new TapirHuntFloraGoal(this));
        this.goalSelector.addGoal(4, (Goal)new TapirTemptGoal(this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 10.0f, 1.6, 1.4, entity -> !((Wolf)entity).isTame()));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TRACKING_TIME, (Object)0);
        builder.define(HAS_BABY_PATTERN, (Object)false);
        builder.define(BEING_TEMPTED, (Object)false);
        builder.define(IS_SNIFFING, (Object)false);
        builder.define(IS_GRAZING, (Object)false);
        builder.define(FLORA_POS, Optional.empty());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        BlockPos florapos;
        super.addAdditionalSaveData(compound);
        compound.putBoolean("BabyPattern", this.hasBabyPattern());
        if (this.floraItem != null) {
            compound.putString("FloraItem", BuiltInRegistries.ITEM.getKey((Object)this.floraItem).toString());
        }
        if ((florapos = this.getFloraPos()) != null) {
            compound.putInt("FloraX", florapos.getX());
            compound.putInt("FloraY", florapos.getY());
            compound.putInt("FloraZ", florapos.getZ());
        }
        compound.putInt("TrackingTime", this.getTrackingTime());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHasBabyPattern(compound.getBoolean("BabyPattern"));
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)compound.getString("FloraItem")));
        if (item != Items.AIR) {
            this.floraItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)compound.getString("FloraItem")));
        }
        if (compound.contains("FloraX", 99) && compound.contains("FloraY", 99) && compound.contains("FloraZ", 99)) {
            BlockPos blockpos = new BlockPos(compound.getInt("FloraX"), compound.getInt("FloraY"), compound.getInt("FloraZ"));
            this.setFloraPos(blockpos);
        }
        this.setTrackingTime(compound.getInt("TrackingTime"));
    }

    public void stopTracking() {
        this.setTrackingTime(0);
        this.setFloraPos(null);
        this.floraItem = null;
        this.loveCause = null;
    }

    public int getTrackingTime() {
        return (Integer)this.entityData.get(TRACKING_TIME);
    }

    public void setTrackingTime(int time) {
        this.entityData.set(TRACKING_TIME, (Object)time);
    }

    public boolean hasBabyPattern() {
        return (Boolean)this.entityData.get(HAS_BABY_PATTERN);
    }

    public void setHasBabyPattern(boolean hasBabyPattern) {
        this.entityData.set(HAS_BABY_PATTERN, (Object)hasBabyPattern);
    }

    public boolean isBeingTempted() {
        return (Boolean)this.entityData.get(BEING_TEMPTED);
    }

    public void setBeingTempted(boolean tempted) {
        this.entityData.set(BEING_TEMPTED, (Object)tempted);
    }

    public boolean isSniffing() {
        return (Boolean)this.entityData.get(IS_SNIFFING);
    }

    public void setSniffing(boolean sniffing) {
        this.entityData.set(IS_SNIFFING, (Object)sniffing);
    }

    public boolean isGrazing() {
        return (Boolean)this.entityData.get(IS_GRAZING);
    }

    public void setGrazing(boolean grazing) {
        this.entityData.set(IS_GRAZING, (Object)grazing);
    }

    public boolean hasFloraPos() {
        return this.getFloraPos() != null;
    }

    public BlockPos getFloraPos() {
        return ((Optional)this.entityData.get(FLORA_POS)).orElse(null);
    }

    public void setFloraPos(BlockPos pos) {
        this.entityData.set(FLORA_POS, Optional.ofNullable(pos));
    }

    public Item getFloraItem() {
        return this.floraItem;
    }

    public boolean hasFloraItem() {
        return this.floraItem != null;
    }

    public float getSnoutRaiseAmount(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.snoutRaiseAmount0, (float)this.snoutRaiseAmount);
    }

    public float getNoAnimAmount(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.noAnimAmount0, (float)this.noAnimAmount);
    }

    public float getNeckAngle(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.neckAngle0, (float)this.neckAngle);
    }

    public float getHeadShakeAnim(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.headShakeAnim0, (float)this.headShakeAnim);
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockitem = (BlockItem)item;
            if (!this.isBaby() && this.isFood(stack)) {
                if (this.getTrackingTime() <= 0) {
                    if (!this.level().isClientSide()) {
                        this.floraItem = blockitem;
                        this.loveCause = player.getUUID();
                        this.setTrackingTime(300);
                        this.level().broadcastEntityEvent((Entity)this, (byte)4);
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                return InteractionResult.PASS;
            }
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        super.tick();
        this.sniffAmount0 = this.sniffAmount;
        this.sniffAmount = this.isSniffing() ? Math.min(1.0f, this.sniffAmount + 0.25f) : Math.max(0.0f, this.sniffAmount - 0.25f);
        this.headShakeAnim0 = this.headShakeAnim;
        if (this.headShakeAnim > 0) {
            --this.headShakeAnim;
        }
        this.noAnimAmount0 = this.noAnimAmount;
        this.noAnimAmount = this.isSniffing() || this.isGrazing() ? Math.min(1.0f, this.noAnimAmount + 0.15f) : Math.max(0.0f, this.noAnimAmount - 0.15f);
        this.neckAngle0 = this.neckAngle;
        if (this.isSniffing()) {
            this.neckAngle = Math.min(1.0f, this.neckAngle + 0.15f);
        } else if (this.isGrazing()) {
            boolean lookup;
            BlockPos florapos = this.getFloraPos();
            boolean bl = lookup = florapos != null && this.level().getBlockState(florapos).getShape((BlockGetter)this.level(), florapos).min(Direction.Axis.Y) + (double)florapos.getY() > this.getEyeY();
            this.neckAngle = lookup ? Math.max(-1.0f, this.neckAngle - 0.15f) : Math.min(1.0f, this.neckAngle + 0.15f);
        } else {
            this.neckAngle = this.neckAngle > 0.0f ? Math.max(0.0f, this.neckAngle - 0.15f) : Math.min(0.0f, this.neckAngle + 0.15f);
        }
        this.snoutRaiseAmount0 = this.snoutRaiseAmount;
        this.snoutRaiseAmount = this.isBeingTempted() ? Math.min(1.0f, this.snoutRaiseAmount + 0.25f) : Math.max(0.0f, this.snoutRaiseAmount - 0.25f);
    }

    public void customServerAiStep() {
        this.setSprinting(!this.isInWater() && this.getMoveControl().hasWanted() && this.running);
        super.customServerAiStep();
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            if (this.getTrackingTime() > 0) {
                if (this.hasFloraPos()) {
                    if (!this.isGrazing()) {
                        if (this.isLeashed()) {
                            this.setTrackingTime(this.getTrackingTime() - 3);
                        } else {
                            this.setTrackingTime(this.getTrackingTime() - 1);
                        }
                        if (this.getTrackingTime() == 0) {
                            this.stopTracking();
                        }
                    }
                } else if (!this.isSniffing()) {
                    this.setTrackingTime(this.getTrackingTime() - 1);
                    if (this.getTrackingTime() == 0) {
                        this.stopTracking();
                    }
                }
            }
            if (this.isSniffing()) {
                if (this.sniffTimer-- <= 0) {
                    this.playSound((SoundEvent)EnvironmentalSoundEvents.TAPIR_SNIFF.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    this.sniffTimer = 10 + this.random.nextInt(20);
                }
            } else {
                this.sniffTimer = 0;
            }
            if (this.tickCount % 20 == 0 && this.isGrazing() && this.hasFloraPos()) {
                this.playSound(SoundEvents.GENERIC_EAT, 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            }
        } else if (this.tickCount % 10 == 0 && this.getTrackingTime() > 0 && this.hasFloraItem()) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)EnvironmentalParticleTypes.TAPIR_FINDS_FLORA.get(), this.getRandomX(0.5), this.getRandomY() + 0.5, this.getRandomZ(0.5), d0, d1, d2);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)EnvironmentalParticleTypes.TAPIR_FINDS_FLORA.get(), this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
        } else if (id == 5) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
        } else if (id == 6) {
            this.headShakeAnim = 20;
            this.headShakeAnim0 = 20;
        } else if (id == 7) {
            if (this.getFloraPos() != null) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vector3d = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.random.nextFloat() - 0.5) * 0.1);
                    vector3d = vector3d.xRot(-this.getXRot() * ((float)Math.PI / 180));
                    vector3d = vector3d.yRot(-this.getYRot() * ((float)Math.PI / 180));
                    double d0 = (double)(-this.random.nextFloat()) * 0.2;
                    Vec3 vector3d1 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.2, d0, 0.9 - 0.05 * (double)this.neckAngle + ((double)this.random.nextFloat() - 0.5) * 0.1);
                    vector3d1 = vector3d1.yRot(-this.yBodyRot * ((float)Math.PI / 180));
                    vector3d1 = vector3d1.add(this.getX(), this.getEyeY() - 0.15 - 0.35 * (double)this.neckAngle, this.getZ());
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.level().getBlockState(this.getFloraPos())), vector3d1.x, vector3d1.y, vector3d1.z, vector3d.x, vector3d.y + 0.05, vector3d.z);
                }
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean canFallInLove() {
        return false;
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    protected SoundEvent getAmbientSound() {
        return this.isSniffing() ? null : (SoundEvent)EnvironmentalSoundEvents.TAPIR_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)EnvironmentalSoundEvents.TAPIR_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EnvironmentalSoundEvents.TAPIR_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        AABB aabb = this.getBoundingBox();
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)(aabb.minX + 0.001)), (int)Mth.floor((double)(aabb.minY + 0.001)), (int)Mth.floor((double)(aabb.minZ + 0.001)), (int)Mth.floor((double)(aabb.maxX - 0.001)), (int)Mth.floor((double)(aabb.maxY - 0.001)), (int)Mth.floor((double)(aabb.maxZ - 0.001)))) {
            if (!(this.level().getBlockState(blockpos).getBlock() instanceof LeavesBlock)) continue;
            this.playSound((SoundEvent)EnvironmentalSoundEvents.TAPIR_LEAF_STEP.get(), 0.6f, 1.0f);
            break;
        }
        this.playSound((SoundEvent)EnvironmentalSoundEvents.TAPIR_STEP.get(), 0.15f, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    public Tapir getBreedOffspring(ServerLevel level, AgeableMob mob) {
        Tapir child = (Tapir)((EntityType)EnvironmentalEntityTypes.TAPIR.get()).create((Level)level);
        child.setHasBabyPattern(true);
        return child;
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.isBaby() && this.random.nextFloat() < 0.9f) {
            this.setHasBabyPattern(false);
        }
    }

    public boolean isFood(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock().defaultBlockState().is(EnvironmentalBlockTags.TRACKABLE_BY_TAPIRS);
        }
        return false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        SpawnGroupData data = super.finalizeSpawn(level, difficulty, spawnType, groupData);
        if (this.isBaby()) {
            this.setHasBabyPattern(true);
        }
        return data;
    }

    protected PathNavigation createNavigation(Level level) {
        return new TapirNavigator((Mob)this, level);
    }

    public static class TapirNavigator
    extends GroundPathNavigation {
        public TapirNavigator(Mob mob, Level level) {
            super(mob, level);
        }

        protected PathFinder createPathFinder(int p_33382_) {
            this.nodeEvaluator = new TapirNodeEvaluator();
            this.nodeEvaluator.setCanPassDoors(true);
            return new PathFinder(this.nodeEvaluator, p_33382_);
        }
    }

    public static class TapirNodeEvaluator
    extends WalkNodeEvaluator {
        public PathType getPathType(PathfindingContext context, int x, int y, int z) {
            PathType type = super.getPathType(context, x, y, z);
            return type == PathType.LEAVES ? PathType.WALKABLE : type;
        }
    }
}

