/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.deer;

import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerAvoidEntityGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerFollowParentGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerFrolicGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerGrazeGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerRunFromAttackerGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.deer.DeerTemptGoal;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;

public abstract class AbstractDeer
extends Animal {
    private static final EntityDimensions GRAZING_DIMENSIONS = EntityDimensions.scalable((float)0.8f, (float)1.2f).withEyeHeight(0.36f);
    private static final Predicate<LivingEntity> AVOID_ENTITY_PREDICATE = entity -> entity.getType().is(EnvironmentalEntityTypeTags.SCARES_DEER) && !entity.isDiscrete() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity);
    private static final Predicate<LivingEntity> TRUSTING_AVOID_ENTITY_PREDICATE = entity -> {
        TamableAnimal tamableAnimal;
        if (!entity.getType().is(EnvironmentalEntityTypeTags.SCARES_TRUSTING_DEER) || entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).isTame()) {
            return false;
        }
        return !entity.isDiscrete() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity);
    };
    private static final TargetingConditions AVOID_ENTITY_TARGETING = TargetingConditions.forNonCombat().range(10.0).selector(AVOID_ENTITY_PREDICATE);
    private static final TargetingConditions TRUSTING_AVOID_ENTITY_TARGETING = TargetingConditions.forNonCombat().range(10.0).selector(TRUSTING_AVOID_ENTITY_PREDICATE);
    private static final EntityDataAccessor<Integer> TARGET_NECK_ANGLE = SynchedEntityData.defineId(AbstractDeer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FLOWER_AMOUNT = SynchedEntityData.defineId(AbstractDeer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> HAS_ANTLERS = SynchedEntityData.defineId(AbstractDeer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TRUSTING = SynchedEntityData.defineId(AbstractDeer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private float neckAngle = 15.0f;
    private float neckAngleO = 15.0f;
    private float sprintAmount;
    private float sprintAmountO;
    private int hopProgress;
    private float hopAmount;
    private float hopAmountO;
    private float hopAngle;
    private float hopAngleO;
    private int floweringTime = 0;
    private final List<BlockState> flowers = new ArrayList<BlockState>();
    @Nullable
    private TemptGoal temptGoal;

    public AbstractDeer(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.temptGoal = new DeerTemptGoal(this, 0.6, 1.1, this.getTemptItems());
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new DeerFollowParentGoal(this));
        this.goalSelector.addGoal(2, (Goal)new DeerRunFromAttackerGoal(this));
        this.goalSelector.addGoal(3, (Goal)new DeerAvoidEntityGoal(this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new DeerFrolicGoal(this));
        this.goalSelector.addGoal(6, (Goal)this.temptGoal);
        this.goalSelector.addGoal(7, (Goal)new DeerGrazeGoal(this));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET_NECK_ANGLE, (Object)15);
        builder.define(FLOWER_AMOUNT, (Object)0);
        builder.define(HAS_ANTLERS, (Object)true);
        builder.define(TRUSTING, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Antlers", this.hasAntlers());
        compound.putBoolean("Trusting", this.isTrusting());
        compound.putInt("FloweringTime", this.floweringTime);
        compound.putInt("FlowerAmount", this.getFlowerAmount());
        ListTag listtag = new ListTag();
        for (BlockState blockstate : this.flowers) {
            if (blockstate == null) continue;
            listtag.add((Object)NbtUtils.writeBlockState((BlockState)blockstate));
        }
        compound.put("Flowers", (Tag)listtag);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHasAntlers(compound.getBoolean("Antlers"));
        this.setTrusting(compound.getBoolean("Trusting"));
        this.floweringTime = compound.getInt("FloweringTime");
        this.setFlowerAmount(compound.getInt("FlowerAmount"));
        ListTag listtag = compound.getList("Flowers", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            BlockState blockstate = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)listtag.getCompound(i));
            if (blockstate == null || blockstate.isAir()) continue;
            this.flowers.add(blockstate);
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void customServerAiStep() {
        this.setSprinting(!this.isInWater() && this.getMoveControl().hasWanted() && this.getMoveControl().getSpeedModifier() >= 1.75);
        super.customServerAiStep();
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide) {
            if (this.getFlowerAmount() > 0 && this.tickCount % 16 == 0) {
                this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
        } else {
            if (this.floweringTime > 0) {
                --this.floweringTime;
            }
            if (this.floweringTime <= 0 && this.getFlowerAmount() > 0 || this.getFlowerAmount() <= 0 && !this.flowers.isEmpty()) {
                this.setFlowerAmount(0);
                this.flowers.clear();
            }
        }
    }

    public void tick() {
        super.tick();
        this.updateNeckAngle();
        this.updateSprintAnimation();
        this.updateHopAnimation();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (this.isTrusting()) {
            if (!this.isBaby() && ((Boolean)EnvironmentalConfig.COMMON.deerFlowerReproducing.get()).booleanValue()) {
                if (stack.is(EnvironmentalItemTags.DEER_FLOWER_ITEMS)) {
                    this.setFlowerAmount(this.getFlowerAmount() + (stack.is(EnvironmentalItemTags.DEER_SUPER_FLOWER_ITEMS) ? 64 : (stack.is(EnvironmentalItemTags.DEER_STRONG_FLOWER_ITEMS) ? 16 : 4)));
                    this.floweringTime += 2400;
                    this.particleCloud((ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                    this.usePlayerItem(player, hand, stack);
                    return InteractionResult.SUCCESS;
                }
                if (this.getFlowerAmount() > 0 && stack.is(EnvironmentalItemTags.DEER_PLANTABLES) && !stack.is(EnvironmentalItemTags.DEER_CANNOT_PLANT) && item instanceof BlockItem) {
                    BlockItem block = (BlockItem)item;
                    if (!this.flowers.contains(block.getBlock().defaultBlockState())) {
                        this.flowers.add(block.getBlock().defaultBlockState());
                        this.floweringTime = Math.max(600, this.floweringTime);
                        this.particleCloud((ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                        this.usePlayerItem(player, hand, stack);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
            }
            return super.mobInteract(player, hand);
        }
        if ((player.isCreative() || this.temptGoal == null || this.temptGoal.isRunning()) && (this.isFood(stack) || stack.is(EnvironmentalItemTags.DEER_FLOWER_ITEMS))) {
            if (!this.level().isClientSide) {
                this.usePlayerItem(player, hand, stack);
                if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                    this.setTrusting(true);
                    this.spawnTrustingParticles(true);
                    this.level().broadcastEntityEvent((Entity)this, (byte)5);
                } else {
                    this.spawnTrustingParticles(false);
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public Ingredient getTemptItems() {
        return Ingredient.of(EnvironmentalItemTags.DEER_TEMPT_ITEMS);
    }

    public void spawnFlower() {
        if (this.isSpreadingFlowers()) {
            BlockPos pos = this.blockPosition();
            BlockState state = this.flowers.get(this.random.nextInt(this.flowers.size()));
            boolean tall = state.getBlock() instanceof DoublePlantBlock;
            if (state.canSurvive((LevelReader)this.level(), pos) && this.level().isEmptyBlock(pos) && (!tall || this.level().isEmptyBlock(pos.above()))) {
                if (!tall) {
                    this.level().setBlock(pos, state, 3);
                } else {
                    DoublePlantBlock.placeAt((LevelAccessor)this.level(), (BlockState)state, (BlockPos)pos, (int)2);
                }
                SoundType sound = state.getSoundType();
                this.playSound(sound.getPlaceSound(), (sound.getVolume() + 1.0f) / 4.0f, sound.getPitch() * 0.8f);
                this.setFlowerAmount(this.getFlowerAmount() - 1);
                this.spawnBoneMealParticles(state, pos);
            }
        }
    }

    private void particleCloud(ParticleOptions particle) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particle, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    private void spawnTrustingParticles(boolean trusts) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        if (!trusts) {
            particleoptions = ParticleTypes.SMOKE;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particleoptions, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    private void spawnBoneMealParticles(BlockState blockstate, BlockPos blockpos) {
        double d1;
        int amount = 15;
        double d0 = 0.5;
        if (blockstate.isSolidRender((BlockGetter)this.level(), blockpos)) {
            blockpos = blockpos.above();
            amount *= 3;
            d0 = 3.0;
            d1 = 1.0;
        } else {
            d1 = blockstate.getShape((BlockGetter)this.level(), blockpos).max(Direction.Axis.Y);
        }
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        RandomSource random = this.level().getRandom();
        for (int i = 0; i < amount; ++i) {
            double d2 = random.nextGaussian() * 0.02;
            double d3 = random.nextGaussian() * 0.02;
            double d4 = random.nextGaussian() * 0.02;
            double d5 = 0.5 - d0;
            double d6 = (double)blockpos.getX() + d5 + random.nextDouble() * d0 * 2.0;
            double d7 = (double)blockpos.getY() + random.nextDouble() * d1;
            double d8 = (double)blockpos.getZ() + d5 + random.nextDouble() * d0 * 2.0;
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, d6, d7, d8, 0, d2, d3, d4, 0.0);
        }
    }

    private void updateNeckAngle() {
        this.neckAngleO = this.neckAngle;
        int i = this.getTargetNeckAngle();
        float f = this.neckAngle + ((float)i - this.neckAngle) * 0.3f;
        this.neckAngle = this.neckAngle < (float)i == f > (float)i ? (float)i : f;
    }

    private void updateSprintAnimation() {
        this.sprintAmountO = this.sprintAmount;
        this.sprintAmount = this.isSprinting() ? Math.min(1.0f, this.sprintAmount + 0.1f) : Math.max(0.0f, this.sprintAmount - 0.1f);
    }

    private void updateHopAnimation() {
        this.hopAmountO = this.hopAmount;
        this.hopAngleO = this.hopAngle;
        if (this.hopProgress != 3) {
            --this.hopProgress;
        } else if (this.onGround() || this.isInWaterOrBubble()) {
            this.hopProgress = 2;
        }
        if (this.hopProgress >= 3) {
            this.hopAngle = this.hopProgress > 3 ? Math.max(-0.2f, this.hopAngle - 0.18f) : Math.min(0.2f, this.hopAngle + 0.08f);
            this.hopAmount = Math.min(1.0f, this.hopAmount + 0.25f);
        } else if (this.hopAngle > 0.0f) {
            this.hopAngle = Math.max(0.0f, this.hopAngle - 0.05f);
        } else if (this.hopAngle < 0.0f) {
            this.hopAngle = Math.min(0.0f, this.hopAngle + 0.05f);
        }
        this.hopAmount = this.hopProgress > 0 ? Math.min(1.0f, this.hopAmount + 0.25f) : Math.max(0.0f, this.hopAmount - 0.25f);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isGrazing()) {
            return GRAZING_DIMENSIONS.scale(this.getAgeScale());
        }
        return super.getDefaultDimensions(pose);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)EnvironmentalSoundEvents.DEER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.DEER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EnvironmentalSoundEvents.DEER_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)EnvironmentalSoundEvents.DEER_STEP.get(), 0.15f, 1.0f);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (TARGET_NECK_ANGLE.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.hopProgress = 10;
        } else if (id == 5) {
            this.spawnTrustingParticles(true);
        } else if (id == 6) {
            this.spawnTrustingParticles(false);
        } else {
            super.handleEntityEvent(id);
        }
    }

    private int getTargetNeckAngle() {
        return (Integer)this.entityData.get(TARGET_NECK_ANGLE);
    }

    public void setTargetNeckAngle(int angle) {
        this.entityData.set(TARGET_NECK_ANGLE, (Object)angle);
    }

    public void resetTargetNeckAngle() {
        this.setTargetNeckAngle(15);
    }

    public float getNeckAngle(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.neckAngleO, (float)this.neckAngle);
    }

    private boolean isGrazing() {
        return this.getTargetNeckAngle() >= 90;
    }

    public float getSprintAmount(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.sprintAmountO, (float)this.sprintAmount);
    }

    public float getHopAmount(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.hopAmountO, (float)this.hopAmount);
    }

    public float getHopAngle(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.hopAngleO, (float)this.hopAngle);
    }

    public boolean isSpreadingFlowers() {
        return this.getFlowerAmount() > 0 && !this.flowers.isEmpty();
    }

    private int getFlowerAmount() {
        return (Integer)this.entityData.get(FLOWER_AMOUNT);
    }

    private void setFlowerAmount(int amount) {
        this.entityData.set(FLOWER_AMOUNT, (Object)amount);
    }

    public void setHasAntlers(boolean antlers) {
        this.entityData.set(HAS_ANTLERS, (Object)antlers);
    }

    public boolean hasAntlers() {
        return (Boolean)this.entityData.get(HAS_ANTLERS);
    }

    public void setTrusting(boolean trusting) {
        this.entityData.set(TRUSTING, (Object)trusting);
    }

    public boolean isTrusting() {
        return (Boolean)this.entityData.get(TRUSTING);
    }

    public LivingEntity getNearestScaryEntity() {
        return this.level().getNearestEntity(this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(10.0, 4.0, 10.0), p_148124_ -> true), this.isTrusting() ? TRUSTING_AVOID_ENTITY_TARGETING : AVOID_ENTITY_TARGETING, (LivingEntity)this, this.getX(), this.getY(), this.getZ());
    }

    public static boolean checkDeerSpawnRules(EntityType<? extends AbstractDeer> deer, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource p_218296_) {
        return level.getBlockState(pos.below()).is(EnvironmentalBlockTags.DEER_SPAWNABLE_ON) && AbstractDeer.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }
}

