/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.deer;

import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import com.teamabnormals.environmental.common.entity.animal.deer.DeerVariant;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.EnvironmentalDataSerializers;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalDeerVariants;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class Deer
extends AbstractDeer
implements VariantHolder<Holder<DeerVariant>> {
    private static final EntityDataAccessor<Holder<DeerVariant>> VARIANT = SynchedEntityData.defineId(Deer.class, (EntityDataSerializer)((EntityDataSerializer)EnvironmentalDataSerializers.DEER_VARIANT.get()));
    private static final EntityDataAccessor<Boolean> SPOTTED = SynchedEntityData.defineId(Deer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Deer(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        Registry registry = this.registryAccess().registryOrThrow(EnvironmentalRegistries.DEER_VARIANT);
        builder.define(VARIANT, (Object)((Holder)registry.getHolder(EnvironmentalDeerVariants.DEFAULT).or(() -> ((Registry)registry).getAny()).orElseThrow()));
        builder.define(SPOTTED, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.getVariant().unwrapKey().ifPresent(variant -> tag.putString("variant", variant.location().toString()));
        tag.putBoolean("spotted", this.hasSpots());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString("variant"))).map(loc -> ResourceKey.create(EnvironmentalRegistries.DEER_VARIANT, (ResourceLocation)loc)).flatMap(key -> this.registryAccess().registryOrThrow(EnvironmentalRegistries.DEER_VARIANT).getHolder(key)).ifPresent(this::setVariant);
        this.setSpotted(tag.getBoolean("spotted"));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(EnvironmentalItemTags.DEER_FOOD);
    }

    public void setVariant(Holder<DeerVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public Holder<DeerVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    public void setSpotted(boolean spotted) {
        this.entityData.set(SPOTTED, (Object)(!this.getVariant().is(EnvironmentalDeerVariants.GRAY) && spotted ? 1 : 0));
    }

    public boolean hasSpots() {
        return (Boolean)this.entityData.get(SPOTTED);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob ageable) {
        Deer entity = (Deer)((EntityType)EnvironmentalEntityTypes.DEER.get()).create((Level)level);
        if (ageable instanceof Deer) {
            Deer partner = (Deer)ageable;
            if (entity != null) {
                entity.setVariant(this.random.nextBoolean() ? partner.getVariant() : this.getVariant());
                entity.setSpotted(this.random.nextBoolean() ? partner.hasSpots() : this.hasSpots());
                entity.setHasAntlers((double)this.random.nextFloat() < (Double)EnvironmentalConfig.COMMON.deerAntlerChance.get());
                entity.setTrusting(this.isTrusting() || partner.isTrusting());
            }
        }
        return entity;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        if (spawnData instanceof DeerSpawnGroupData) {
            DeerSpawnGroupData deerSpawnGroupData = (DeerSpawnGroupData)spawnData;
            this.setVariant(deerSpawnGroupData.type);
        } else {
            Holder biome = level.getBiome(this.blockPosition());
            Holder<DeerVariant> variant = DeerVariant.getSpawnVariant(this.registryAccess(), (Holder<Biome>)biome);
            spawnData = new DeerSpawnGroupData(variant);
            this.setVariant(variant);
        }
        this.setSpotted(this.random.nextBoolean());
        this.setHasAntlers((double)this.random.nextFloat() < (Double)EnvironmentalConfig.COMMON.deerAntlerChance.get());
        return super.finalizeSpawn(level, difficulty, reason, spawnData);
    }

    public static class DeerSpawnGroupData
    extends AgeableMob.AgeableMobGroupData
    implements SpawnGroupData {
        public final Holder<DeerVariant> type;

        public DeerSpawnGroupData(Holder<DeerVariant> type) {
            super(0.3f);
            this.type = type;
        }
    }
}

