/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.deer;

import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Reindeer
extends AbstractDeer {
    private static final EntityDataAccessor<Boolean> HOLIDAY = SynchedEntityData.defineId(Reindeer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Reindeer(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOLIDAY, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Holiday", this.isHoliday());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHoliday(compound.getBoolean("Holiday"));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(EnvironmentalItemTags.REINDEER_FOOD);
    }

    @Override
    public Ingredient getTemptItems() {
        return Ingredient.of(EnvironmentalItemTags.REINDEER_TEMPT_ITEMS);
    }

    private void setHoliday(boolean isHoliday) {
        this.entityData.set(HOLIDAY, (Object)isHoliday);
    }

    public boolean isHoliday() {
        return (Boolean)this.entityData.get(HOLIDAY);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob ageable) {
        Reindeer entity = (Reindeer)((EntityType)EnvironmentalEntityTypes.REINDEER.get()).create((Level)level);
        Reindeer partner = (Reindeer)ageable;
        if (entity != null) {
            entity.setHasAntlers(true);
            entity.setTrusting(this.isTrusting() || partner.isTrusting());
            entity.setHoliday(this.isHolidayCriteria());
        }
        return entity;
    }

    private boolean isHolidayCriteria() {
        return this.random.nextInt(9) == 0 && LocalDate.now().get(ChronoField.MONTH_OF_YEAR) == 12;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setHasAntlers(true);
        this.setHoliday(this.isHolidayCriteria());
        return super.finalizeSpawn(worldIn, difficulty, reason, spawnDataIn);
    }
}

