/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.koi;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public record KoiVariant(ResourceLocation texture, Component description) {
    public static final Codec<KoiVariant> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(KoiVariant::texture), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(KoiVariant::description)).apply((Applicative)instance, KoiVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, KoiVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, KoiVariant::texture, (StreamCodec)ComponentSerialization.STREAM_CODEC, KoiVariant::description, KoiVariant::new);
    public static final Codec<Holder<KoiVariant>> CODEC = RegistryFileCodec.create(EnvironmentalRegistries.KOI_VARIANT, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<KoiVariant>> STREAM_CODEC = ByteBufCodecs.holder(EnvironmentalRegistries.KOI_VARIANT, DIRECT_STREAM_CODEC);

    public static Holder<KoiVariant> getRandomVariant(RegistryAccess registryAccess, RandomSource random) {
        Registry registry = registryAccess.registryOrThrow(EnvironmentalRegistries.KOI_VARIANT);
        List variants = registry.holders().toList();
        return (Holder)variants.get(random.nextInt(variants.size()));
    }

    public static Holder<KoiVariant> getNoiseVariant(RegistryAccess registryAccess, double noise) {
        Registry registry = registryAccess.registryOrThrow(EnvironmentalRegistries.KOI_VARIANT);
        List variants = registry.holders().toList();
        return (Holder)variants.get((int)(noise * (double)variants.size()));
    }
}

