/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.slabfish;

import com.teamabnormals.blueprint.common.network.particle.SpawnParticlesPayload;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.environmental.common.entity.ai.goal.slabfish.SlabbyFollowParentGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.slabfish.SlabbyGrabItemGoal;
import com.teamabnormals.environmental.common.entity.animal.slabfish.SlabfishOverlay;
import com.teamabnormals.environmental.common.inventory.SlabfishInventory;
import com.teamabnormals.environmental.common.inventory.SlabfishInventoryMenu;
import com.teamabnormals.environmental.common.network.message.OpenSlabfishInventoryPayload;
import com.teamabnormals.environmental.common.slabfish.SlabfishBackpack;
import com.teamabnormals.environmental.common.slabfish.SlabfishHelper;
import com.teamabnormals.environmental.common.slabfish.SlabfishSweater;
import com.teamabnormals.environmental.common.slabfish.SlabfishVariant;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.teamabnormals.environmental.core.other.EnvironmentalCriteriaTriggers;
import com.teamabnormals.environmental.core.other.EnvironmentalDataSerializers;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalSlabfishVariantTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import com.teamabnormals.environmental.core.registry.datapack.slabfish.EnvironmentalSlabfishBackpacks;
import com.teamabnormals.environmental.core.registry.datapack.slabfish.EnvironmentalSlabfishOverlays;
import com.teamabnormals.environmental.core.registry.datapack.slabfish.EnvironmentalSlabfishVariants;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class Slabfish
extends TamableAnimal
implements ContainerListener,
Bucketable,
VariantHolder<Holder<SlabfishVariant>> {
    private static final EntityDataAccessor<Holder<SlabfishVariant>> VARIANT = SynchedEntityData.defineId(Slabfish.class, (EntityDataSerializer)((EntityDataSerializer)EnvironmentalDataSerializers.SLABFISH_VARIANT.get()));
    private static final EntityDataAccessor<Optional<Holder<SlabfishBackpack>>> BACKPACK = SynchedEntityData.defineId(Slabfish.class, (EntityDataSerializer)((EntityDataSerializer)EnvironmentalDataSerializers.SLABFISH_BACKPACK_VARIANT.get()));
    private static final EntityDataAccessor<Optional<Holder<SlabfishSweater>>> SWEATER = SynchedEntityData.defineId(Slabfish.class, (EntityDataSerializer)((EntityDataSerializer)EnvironmentalDataSerializers.SLABFISH_SWEATER_VARIANT.get()));
    private static final EntityDataAccessor<Optional<Holder<SlabfishOverlay>>> OVERLAY = SynchedEntityData.defineId(Slabfish.class, (EntityDataSerializer)((EntityDataSerializer)EnvironmentalDataSerializers.SLABFISH_OVERLAY.get()));
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(Slabfish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDimensions SIZE_SWIMMING = EntityDimensions.scalable((float)0.7f, (float)0.6f).withEyeHeight(0.513f);
    public static final EntityDimensions SIZE_SITTING = EntityDimensions.scalable((float)0.45f, (float)0.6f).withEyeHeight(0.36f);
    public static final EntityDimensions SIZE_SWIMMING_CHILD = EntityDimensions.scalable((float)0.35f, (float)0.3f).withEyeHeight(0.42f);
    public static final EntityDimensions SIZE_SITTING_CHILD = EntityDimensions.scalable((float)0.225f, (float)0.3f).withEyeHeight(0.18f);
    public static final String VARIANT_TAG = "SlabfishVariant";
    public static final String BACKPACK_TAG = "SlabfishBackpack";
    public static final String SWEATER_TAG = "SlabfishSweater";
    public static final String OVERLAY_TAG = "SlabfishOverlay";
    public static final String BUCKET_TAG = "FromBucket";
    public static final String BUCKET_VARIANT_TAG = "BucketVariantTag";
    public SlabfishInventory slabfishBackpack;
    public boolean backpackFull;
    public int playersUsing;
    private UUID lightningUUID;
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    public boolean isPartying = false;
    BlockPos jukeboxPosition;
    private boolean clearing;

    public Slabfish(EntityType<? extends Slabfish> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.slabfishBackpack = new SlabfishInventory(this);
        this.slabfishBackpack.addListener(this);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, entity -> entity.getType().is(EntityTypeTags.RAIDERS), 15.0f, 1.0, 1.25, EntitySelector.NO_CREATIVE_OR_SPECTATOR::test));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new SlabbyGrabItemGoal(this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(EnvironmentalItemTags.SLABFISH_FOOD), false));
        this.goalSelector.addGoal(8, (Goal)new SlabbyFollowParentGoal(this, 1.1));
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        Registry<SlabfishVariant> slabfishRegistry = SlabfishHelper.slabfishTypes(this.registryAccess());
        builder.define(VARIANT, (Object)((Holder)slabfishRegistry.getHolder(EnvironmentalSlabfishVariants.SWAMP).or(() -> slabfishRegistry.getAny()).orElseThrow()));
        builder.define(OVERLAY, Optional.empty());
        builder.define(BACKPACK, Optional.empty());
        builder.define(SWEATER, Optional.empty());
        builder.define(FROM_BUCKET, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.getVariant().unwrapKey().ifPresent(variant -> tag.putString(VARIANT_TAG, variant.location().toString()));
        this.getSweater().flatMap(Holder::unwrapKey).ifPresent(sweater -> tag.putString(SWEATER_TAG, sweater.location().toString()));
        this.getBackpack().flatMap(Holder::unwrapKey).ifPresent(backpack -> tag.putString(BACKPACK_TAG, backpack.location().toString()));
        this.getOverlay().flatMap(Holder::unwrapKey).ifPresent(overlay -> tag.putString(OVERLAY_TAG, overlay.location().toString()));
        tag.putBoolean(BUCKET_TAG, this.fromBucket());
        this.slabfishBackpack.write(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        Registry<SlabfishVariant> slabfishRegistry = SlabfishHelper.slabfishTypes(this.registryAccess());
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(VARIANT_TAG))).flatMap(arg_0 -> slabfishRegistry.getHolder(arg_0)).ifPresent(this::setVariant);
        Registry<SlabfishBackpack> backpackRegistry = SlabfishHelper.slabfishBackpacks(this.registryAccess());
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(BACKPACK_TAG))).flatMap(arg_0 -> backpackRegistry.getHolder(arg_0)).ifPresent(this::setBackpack);
        Registry<SlabfishSweater> sweaterRegistry = SlabfishHelper.slabfishSweaters(this.registryAccess());
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(SWEATER_TAG))).flatMap(arg_0 -> sweaterRegistry.getHolder(arg_0)).ifPresent(this::setSweater);
        Registry<SlabfishOverlay> overlayRegistry = SlabfishHelper.slabfishOverlays(this.registryAccess());
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(OVERLAY_TAG))).flatMap(arg_0 -> overlayRegistry.getHolder(arg_0)).ifPresent(this::setOverlay);
        this.setFromBucket(tag.getBoolean(BUCKET_TAG));
        this.slabfishBackpack.read(tag);
        this.updateSweater();
        this.updateBackpack();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        Holder<SlabfishVariant> slabfishVariant = this.getVariant();
        if (item == Items.WATER_BUCKET && this.isAlive() && (!this.isTame() || player.isSecondaryUseActive())) {
            this.dropLeash(true, true);
            if (this.hasBackpack()) {
                this.dropBackpack();
            }
            return (InteractionResult)Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).get();
        }
        if (stack.is(ItemTags.CREEPER_DROP_MUSIC_DISCS)) {
            this.usePlayerItem(player, hand, stack);
            this.playBurpSound();
            this.particleCloud((ParticleOptions)ParticleTypes.NOTE);
            this.dropItem((ItemLike)EnvironmentalItems.MUSIC_DISC_SLABRAVE.get());
            return InteractionResult.SUCCESS;
        }
        if (this.isTame()) {
            Registry<SlabfishBackpack> backpacks = SlabfishHelper.slabfishBackpacks(this.registryAccess());
            if (this.hasBackpack() && SlabfishHelper.getBackpackType(backpacks, stack).isPresent() && !SlabfishHelper.getBackpackType(backpacks, stack).get().is(this.getBackpack().get())) {
                if (!this.level().isClientSide()) {
                    ItemStack previousBackpack = this.slabfishBackpack.getItem(2);
                    if (!previousBackpack.isEmpty()) {
                        Containers.dropItemStack((Level)this.level(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)previousBackpack.copy());
                        this.slabfishBackpack.removeItemNoUpdate(2);
                    }
                    this.slabfishBackpack.setItem(2, new ItemStack((ItemLike)item));
                    this.usePlayerItem(player, hand, stack);
                    this.playBackpackDyeSound();
                }
                return InteractionResult.SUCCESS;
            }
            Registry<SlabfishSweater> sweaters = SlabfishHelper.slabfishSweaters(this.registryAccess());
            if (!(!SlabfishHelper.getSweaterType(sweaters, stack).isPresent() || player.isSecondaryUseActive() || this.hasSweater() && SlabfishHelper.getSweaterType(sweaters, stack).get().is(this.getSweater().get()))) {
                if (!this.level().isClientSide()) {
                    ItemStack previousSweater = this.slabfishBackpack.getItem(0);
                    if (!previousSweater.isEmpty()) {
                        Containers.dropItemStack((Level)this.level(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)previousSweater.copy());
                        this.slabfishBackpack.removeItemNoUpdate(0);
                    }
                    this.slabfishBackpack.setItem(0, new ItemStack((ItemLike)item));
                    this.usePlayerItem(player, hand, stack);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.is(Tags.Items.CHESTS_WOODEN) && !this.hasBackpack()) {
                if (!this.level().isClientSide()) {
                    this.slabfishBackpack.setItem(1, new ItemStack((ItemLike)item));
                    this.usePlayerItem(player, hand, stack);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ((PlayerTrigger)EnvironmentalCriteriaTriggers.BACKPACK_SLABFISH.get()).trigger(serverPlayer);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (item == Items.SHEARS && this.hasSweater() && !player.isSecondaryUseActive()) {
                ItemStack previousSweater = this.slabfishBackpack.getItem(0);
                if (!previousSweater.isEmpty()) {
                    Containers.dropItemStack((Level)this.level(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)previousSweater.copy());
                    this.slabfishBackpack.removeItemNoUpdate(0);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.isSecondaryUseActive() && stack.is(Tags.Items.TOOLS_SHEAR) && this.hasBackpack()) {
                this.dropBackpack();
                return InteractionResult.SUCCESS;
            }
            if (this.isFood(stack) && this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(player, hand, stack);
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)EnvironmentalSoundEvents.SLABFISH_EAT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, true);
                this.heal(item.getFoodProperties(stack, (LivingEntity)player).nutrition());
                this.particleCloud((ParticleOptions)ParticleTypes.COMPOSTER);
                return InteractionResult.SUCCESS;
            }
            if (Ingredient.of(EnvironmentalItemTags.SLABFISH_SNACKS).test(stack)) {
                stack.finishUsingItem(this.level(), (LivingEntity)this);
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)EnvironmentalSoundEvents.SLABFISH_EAT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, true);
                return InteractionResult.SUCCESS;
            }
            if (this.isFood(stack)) {
                int i = this.getAge();
                if (!this.level().isClientSide && i == 0 && this.canFallInLove()) {
                    this.usePlayerItem(player, hand, stack);
                    this.setInLove(player);
                    return InteractionResult.SUCCESS;
                }
                if (this.isBaby()) {
                    this.usePlayerItem(player, hand, stack);
                    this.ageUp((int)((float)(-i / 20) * 0.1f), true);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                if (this.level().isClientSide) {
                    return InteractionResult.CONSUME;
                }
            }
            if (!this.isOrderedToSit() && this.isOwnedBy((LivingEntity)player) && player.isSecondaryUseActive() && !this.isInWater()) {
                this.setOwnerUUID(player.getUUID());
                if (!this.level().isClientSide()) {
                    this.setOrderedToSit(true);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isOrderedToSit() && this.isOwnedBy((LivingEntity)player) && player.isSecondaryUseActive()) {
                if (!this.level().isClientSide()) {
                    this.setOrderedToSit(false);
                }
                return InteractionResult.SUCCESS;
            }
            if (!player.isSecondaryUseActive()) {
                if (!this.level().isClientSide()) {
                    this.openGui((ServerPlayer)player);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (stack.is(EnvironmentalItemTags.SLABFISH_TAME_ITEMS)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                this.tame(player);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    protected void onInsideBlock(BlockState state) {
        if (state.getBlock() == Blocks.WATER && this.hasOverlay()) {
            this.setOverlay(null);
        }
    }

    public boolean isPartying() {
        return this.isPartying;
    }

    public void setRecordPlayingNearby(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.isPartying = isPartying;
    }

    public void aiStep() {
        super.aiStep();
        if (this.jukeboxPosition == null || !this.jukeboxPosition.closerThan((Vec3i)this.blockPosition(), 3.46) || this.level().getBlockState(this.jukeboxPosition).getBlock() != Blocks.JUKEBOX) {
            this.isPartying = false;
            this.jukeboxPosition = null;
        }
        if (this.getVehicle() != null && this.getVehicle().isShiftKeyDown()) {
            this.stopRiding();
        }
        if (this.isInWater() && this.getVehicle() != null) {
            this.stopRiding();
        }
        if (this.isMoving() && this.hasEffect(MobEffects.MOVEMENT_SPEED) && this.random.nextInt(3) == 0 && !this.isInWater()) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getRandomX(0.5), this.getY() + 0.2, this.getRandomZ(0.5), d0, d1, d2);
        }
        if (this.random.nextFloat() < 0.1f && this.hasOverlay() && this.getOverlay().get().is(EnvironmentalSlabfishOverlays.MUD)) {
            for (int i = 0; i < this.random.nextInt(2) + 1; ++i) {
                this.doParticle(this.level(), this.getX() - (double)0.3f, this.getX() + (double)0.3f, this.getZ() - (double)0.3f, this.getZ() + (double)0.3f, this.getY(0.5), (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)EnvironmentalItems.MUD_BALL.get())));
            }
        }
        this.refreshDimensions();
        this.setCanPickUpLoot(this.hasBackpack());
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.onGround() ? -1 : 4) * 0.3);
        this.destPos = Mth.clamp((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.onGround()) {
            if (!this.isInWater() && this.getDeltaMovement().y < 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
            }
            if (this.wingRotDelta < 1.0f) {
                this.wingRotDelta = 1.0f;
            }
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    private boolean isMoving() {
        return this.getDeltaMovement().x() > 0.0 || this.getDeltaMovement().y() > 0.0 || this.getDeltaMovement().z() > 0.0;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (this.getVehicle() != null) {
            this.stopRiding();
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.hurt(source, amount);
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.SLABFISH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EnvironmentalSoundEvents.SLABFISH_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)EnvironmentalSoundEvents.SLABFISH_STEP.get(), 0.15f, 1.0f);
    }

    protected void playBackpackSound() {
        this.playSound((SoundEvent)EnvironmentalSoundEvents.SLABFISH_BACKPACK.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    protected void playBackpackDyeSound() {
        this.playSound(SoundEvents.DYE_USE, 1.0f, 1.0f);
    }

    protected void playSweaterSound() {
        this.playSound((SoundEvent)EnvironmentalSoundEvents.SLABFISH_SWEATER.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    protected void playBurpSound() {
        this.playSound((SoundEvent)EnvironmentalSoundEvents.SLABFISH_BURP.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    private void doParticle(Level world, double p_226397_2_, double p_226397_4_, double p_226397_6_, double p_226397_8_, double p_226397_10_, ParticleOptions p_226397_12_) {
        world.addParticle(p_226397_12_, Mth.lerp((double)world.random.nextDouble(), (double)p_226397_2_, (double)p_226397_4_), p_226397_10_, Mth.lerp((double)world.random.nextDouble(), (double)p_226397_6_, (double)p_226397_8_), 0.0, 0.0, 0.0);
    }

    private void particleCloud(ParticleOptions particle) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particle, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    private void dropItem(ItemLike item) {
        ItemEntity itementity = this.spawnAtLocation(item, 0);
        if (itementity != null) {
            itementity.setDeltaMovement(itementity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
    }

    public Slabfish getBreedOffspring(ServerLevel level, AgeableMob ageable) {
        Slabfish baby = (Slabfish)((EntityType)EnvironmentalEntityTypes.SLABFISH.get()).create((Level)level);
        if (baby != null && ageable instanceof Slabfish) {
            Slabfish parent = (Slabfish)ageable;
            baby.setPos(this.position());
            Registry<SlabfishVariant> registry = SlabfishHelper.slabfishTypes(this.registryAccess());
            Optional<Holder.Reference<SlabfishVariant>> slabfishVariant = SlabfishHelper.getSlabfishType(registry, SlabfishConditionContext.breeding(baby, this.getLoveCause(), this, parent));
            Holder<SlabfishVariant> babyVariant = slabfishVariant.isPresent() ? (Holder<SlabfishVariant>)slabfishVariant.get() : (this.random.nextBoolean() ? this.getVariant() : parent.getVariant());
            baby.setVariant(babyVariant);
            if (this.isTame()) {
                baby.setOwnerUUID(this.getOwnerUUID());
                baby.setTame(true, true);
            }
        }
        return baby;
    }

    public boolean isFood(ItemStack stack) {
        return !Ingredient.of(EnvironmentalItemTags.SLABFISH_TAME_ITEMS).test(stack) && Ingredient.of(EnvironmentalItemTags.SLABFISH_FOOD).test(stack);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isInWater() ? (this.isBaby() ? SIZE_SWIMMING_CHILD : SIZE_SWIMMING) : (this.isInSittingPose() || this.getVehicle() != null ? (this.isBaby() ? SIZE_SITTING_CHILD : SIZE_SITTING) : super.getDefaultDimensions(pose));
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public int getMaxSpawnClusterSize() {
        return 5;
    }

    protected float getWaterSlowDown() {
        return 0.96f;
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        if (!this.level().isClientSide() && name != null && !this.getVariant().is(EnvironmentalSlabfishVariants.GHOST)) {
            Registry<SlabfishVariant> registry = SlabfishHelper.slabfishTypes(this.registryAccess());
            Holder<SlabfishVariant> currentType = this.getVariant();
            SlabfishHelper.getSlabfishType(registry, SlabfishConditionContext.rename(this)).ifPresent(newType -> {
                if (!SlabfishVariant.canBeSold(currentType) && SlabfishVariant.canBeSold((Holder<SlabfishVariant>)newType)) {
                    return;
                }
                if (!newType.is(currentType)) {
                    this.setVariant((Holder<SlabfishVariant>)newType);
                    this.playTransformSound();
                }
            });
        }
    }

    public void playTransformSound() {
        this.playSound((SoundEvent)EnvironmentalSoundEvents.SLABFISH_TRANSFORM.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            NetworkUtil.spawnParticle((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, List.of(new SpawnParticlesPayload.ParticleInstance(this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2)));
        }
    }

    public void thunderHit(ServerLevel world, LightningBolt lightningBolt) {
        UUID uuid = lightningBolt.getUUID();
        if (!(world.isClientSide() || uuid.equals(this.lightningUUID) || this.getVariant().is(EnvironmentalSlabfishVariants.GHOST) || this.getVariant().is(EnvironmentalSlabfishVariants.GOLEM))) {
            Registry<SlabfishVariant> registry = SlabfishHelper.slabfishTypes(this.registryAccess());
            Holder<SlabfishVariant> currentType = this.getVariant();
            SlabfishHelper.getSlabfishType(registry, SlabfishConditionContext.lightning(this)).ifPresent(newType -> {
                if (!SlabfishVariant.canBeSold(currentType) && SlabfishVariant.canBeSold((Holder<SlabfishVariant>)newType)) {
                    return;
                }
                this.setVariant((Holder<SlabfishVariant>)newType);
                this.lightningUUID = uuid;
                this.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 2.0f, 1.0f);
            });
        }
    }

    public void setVariant(Holder<SlabfishVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public Holder<SlabfishVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    public void setBackpack(Holder<SlabfishBackpack> variant) {
        this.entityData.set(BACKPACK, Optional.ofNullable(variant));
    }

    public Optional<Holder<SlabfishBackpack>> getBackpack() {
        return (Optional)this.entityData.get(BACKPACK);
    }

    public boolean hasBackpack() {
        return this.getBackpack().isPresent();
    }

    public void setSweater(Holder<SlabfishSweater> variant) {
        this.entityData.set(SWEATER, Optional.ofNullable(variant));
    }

    public Optional<Holder<SlabfishSweater>> getSweater() {
        return (Optional)this.entityData.get(SWEATER);
    }

    public boolean hasSweater() {
        return this.getSweater().isPresent();
    }

    public void setOverlay(Holder<SlabfishOverlay> variant) {
        this.entityData.set(OVERLAY, Optional.ofNullable(variant));
    }

    public Optional<Holder<SlabfishOverlay>> getOverlay() {
        return (Optional)this.entityData.get(OVERLAY);
    }

    public boolean hasOverlay() {
        return this.getOverlay().isPresent();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        if (reason == MobSpawnType.BUCKET) {
            return spawnDataIn;
        }
        if (spawnDataIn instanceof SlabfishData) {
            SlabfishData slabfishData = (SlabfishData)spawnDataIn;
            this.setVariant(slabfishData.type);
            return spawnDataIn;
        }
        Registry<SlabfishVariant> registry = SlabfishHelper.slabfishTypes(this.registryAccess());
        Holder type = (Holder)SlabfishHelper.getSlabfishType(registry, SlabfishConditionContext.spawned(this)).orElse((Holder.Reference<SlabfishVariant>)registry.getHolderOrThrow(EnvironmentalSlabfishVariants.SWAMP));
        spawnDataIn = new SlabfishData((Holder<SlabfishVariant>)type);
        this.setVariant((Holder<SlabfishVariant>)type);
        return super.finalizeSpawn(world, difficulty, reason, spawnDataIn);
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean value) {
        this.entityData.set(FROM_BUCKET, (Object)value);
    }

    public void loadFromBucketTag(CompoundTag tag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)tag);
        if (tag.contains(BUCKET_VARIANT_TAG, 8)) {
            if (tag.contains("Age")) {
                this.setAge(tag.getInt("Age"));
            }
            if (tag.contains("Owner")) {
                this.setTame(true, true);
                this.setOwnerUUID(tag.getUUID("Owner"));
            }
            Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(BUCKET_VARIANT_TAG))).flatMap(key -> SlabfishHelper.slabfishTypes(this.registryAccess()).getHolder(key)).ifPresent(this::setVariant);
            Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(BACKPACK_TAG))).flatMap(key -> SlabfishHelper.slabfishBackpacks(this.registryAccess()).getHolder(key)).ifPresent(this::setBackpack);
            Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(SWEATER_TAG))).flatMap(key -> SlabfishHelper.slabfishSweaters(this.registryAccess()).getHolder(key)).ifPresent(this::setSweater);
            this.slabfishBackpack.read(tag);
            this.updateSweater();
            this.updateBackpack();
        } else {
            TagKey<SlabfishVariant> rarity = SlabfishVariant.getRandomRarity(this.random.nextFloat());
            Registry<SlabfishVariant> registry = SlabfishHelper.slabfishTypes(this.registryAccess());
            Optional<Holder<SlabfishVariant>> type = SlabfishHelper.getRandomSlabfishType(registry, s -> !s.is(EnvironmentalSlabfishVariantTags.NOT_SOLD_BY_WANDERING_TRADER) && s.is(rarity), this.level().getRandom());
            type.ifPresent(this::setVariant);
        }
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public void saveToBucketTag(ItemStack bucket) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)bucket);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, tag -> {
            tag.putInt("Age", this.getAge());
            if (this.getOwnerUUID() != null && this.isTame()) {
                tag.putUUID("Owner", this.getOwnerUUID());
            }
            this.getVariant().unwrapKey().ifPresent(variant -> tag.putString(BUCKET_VARIANT_TAG, variant.location().toString()));
            this.getBackpack().flatMap(Holder::unwrapKey).ifPresent(backpack -> tag.putString(BACKPACK_TAG, backpack.location().toString()));
            this.getSweater().flatMap(Holder::unwrapKey).ifPresent(sweater -> tag.putString(SWEATER_TAG, sweater.location().toString()));
            this.slabfishBackpack.write((CompoundTag)tag);
        });
    }

    private void updateSweater() {
        if (!this.level().isClientSide()) {
            ItemStack sweaterStack = this.slabfishBackpack.getItem(0);
            Registry<SlabfishSweater> sweaters = SlabfishHelper.slabfishSweaters(this.registryAccess());
            SlabfishHelper.getSweaterType(sweaters, sweaterStack).ifPresentOrElse(this::setSweater, () -> this.setSweater(null));
        }
    }

    private void updateBackpack() {
        if (!this.level().isClientSide()) {
            if (!this.slabfishBackpack.getItem(1).isEmpty() && this.slabfishBackpack.getItem(1).is(Tags.Items.CHESTS_WOODEN)) {
                SlabfishVariant slabfishVariant = (SlabfishVariant)this.getVariant().value();
                Optional<Holder<SlabfishBackpack>> backpackType = slabfishVariant.backpackOverride();
                Registry<SlabfishBackpack> registry = SlabfishHelper.slabfishBackpacks(this.registryAccess());
                ItemStack backpackColorStack = this.slabfishBackpack.getItem(2);
                this.setBackpack((Holder<SlabfishBackpack>)((Holder)SlabfishHelper.getBackpackType(registry, backpackColorStack).orElse((Holder.Reference<SlabfishBackpack>)((Holder.Reference)backpackType.orElse((Holder<SlabfishBackpack>)registry.getHolderOrThrow(EnvironmentalSlabfishBackpacks.BROWN))))));
            } else {
                this.setBackpack(null);
            }
        }
    }

    public void openGui(ServerPlayer player) {
        if (player.containerMenu != player.inventoryMenu) {
            player.closeContainer();
        }
        player.nextContainerCounter();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OpenSlabfishInventoryPayload(this, player.containerCounter), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.containerMenu = new SlabfishInventoryMenu(player.containerCounter, player.getInventory(), this.slabfishBackpack, this);
        player.initMenu(player.containerMenu);
        NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.containerMenu));
    }

    public boolean canHoldItem(ItemStack stack) {
        return this.hasBackpack();
    }

    public boolean canTakeItem(ItemStack stack) {
        return this.hasBackpack();
    }

    protected void dropEquipment() {
        ItemStack itemstack = this.slabfishBackpack.removeItemNoUpdate(0);
        if (!itemstack.isEmpty() && !EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
            this.spawnAtLocation(itemstack);
        }
        this.dropBackpack();
    }

    protected void dropBackpack() {
        super.dropEquipment();
        if (this.hasBackpack() && this.slabfishBackpack != null) {
            for (int i = this.slabfishBackpack.getContainerSize(); i > 0; --i) {
                ItemStack itemstack = this.slabfishBackpack.removeItemNoUpdate(i);
                if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                this.spawnAtLocation(itemstack);
            }
        }
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        if (itemEntity.getOwner() == this) {
            return;
        }
        ItemStack itemstack = itemEntity.getItem();
        if (this.hasBackpack()) {
            ItemStack stack = this.slabfishBackpack.addItem(itemstack, 3, this.slabfishBackpack.getContainerSize());
            if (!ItemStack.matches((ItemStack)itemstack, (ItemStack)stack)) {
                this.take((Entity)itemEntity, itemstack.getCount() - stack.getCount());
            }
            if (stack.isEmpty()) {
                itemEntity.discard();
            } else {
                itemEntity.setItem(stack);
            }
        }
    }

    public void containerChanged(Container invBasic) {
        boolean hasBackpack;
        if (this.clearing) {
            return;
        }
        boolean hadSweater = this.hasSweater();
        boolean hadBackpack = this.hasBackpack();
        this.updateSweater();
        boolean bl = hasBackpack = !this.slabfishBackpack.getItem(1).isEmpty() && this.slabfishBackpack.getItem(1).is(Tags.Items.CHESTS_WOODEN);
        if (!hadSweater && this.hasSweater()) {
            this.playSweaterSound();
        }
        if (hadBackpack != hasBackpack) {
            this.playBackpackSound();
        }
        if (hadBackpack && !hasBackpack) {
            this.clearing = true;
            this.dropBackpack();
            this.clearing = false;
        }
        this.updateBackpack();
        if (this.hasBackpack()) {
            this.backpackFull = true;
            for (int i = 3; i < this.slabfishBackpack.getContainerSize(); ++i) {
                ItemStack stack = this.slabfishBackpack.getItem(i);
                if (!stack.isEmpty() && stack.getCount() >= stack.getMaxStackSize()) continue;
                this.backpackFull = false;
                break;
            }
        } else {
            this.backpackFull = false;
        }
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)EnvironmentalItems.SLABFISH_BUCKET.get());
    }

    public static class SlabfishData
    extends AgeableMob.AgeableMobGroupData
    implements SpawnGroupData {
        public final Holder<SlabfishVariant> type;

        public SlabfishData(Holder<SlabfishVariant> type) {
            super(true);
            this.type = type;
        }
    }
}

