/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.slabfish;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.environmental.common.slabfish.SlabfishHelper;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record SlabfishOverlay(ResourceLocation texture, Optional<ResourceLocation> backpackTexture, Optional<Holder<Item>> item, Optional<TagKey<Item>> tagKey) {
    public static final Codec<SlabfishOverlay> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(entry -> entry.texture), (App)ResourceLocation.CODEC.optionalFieldOf("backpack_texture").forGetter(entry -> entry.backpackTexture), (App)RegistryFixedCodec.create((ResourceKey)Registries.ITEM).optionalFieldOf("projectile_item").forGetter(entry -> entry.item), (App)TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("projectile_item_tag").forGetter(entry -> entry.tagKey)).apply((Applicative)instance, SlabfishOverlay::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SlabfishOverlay> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, SlabfishOverlay::texture, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), SlabfishOverlay::backpackTexture, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM)), SlabfishOverlay::item, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)TagKey.codec((ResourceKey)Registries.ITEM))), SlabfishOverlay::tagKey, SlabfishOverlay::new);
    public static final Codec<Holder<SlabfishOverlay>> CODEC = RegistryFileCodec.create(EnvironmentalRegistries.SLABFISH_OVERLAY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<SlabfishOverlay>> STREAM_CODEC = ByteBufCodecs.holder(EnvironmentalRegistries.SLABFISH_OVERLAY, DIRECT_STREAM_CODEC);

    public static Optional<Holder.Reference<SlabfishOverlay>> getOverlayForItem(RegistryAccess access, ItemStack item) {
        Optional<Holder.Reference<SlabfishOverlay>> overlay = SlabfishHelper.slabfishOverlays(access).holders().filter(holder -> ((SlabfishOverlay)holder.value()).item.isPresent() && item.is(((SlabfishOverlay)holder.value()).item.get())).findAny();
        if (overlay.isEmpty()) {
            overlay = SlabfishHelper.slabfishOverlays(access).holders().filter(holder -> ((SlabfishOverlay)holder.value()).tagKey.isPresent() && item.is(((SlabfishOverlay)holder.value()).tagKey().get())).findAny();
        }
        return overlay;
    }
}

