/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.zebroid;

import com.teamabnormals.environmental.common.entity.ai.goal.HerdLandWanderGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebraFleeGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidFollowParentGoal;
import com.teamabnormals.environmental.common.entity.animal.zebroid.AbstractUnchestedZebroid;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zonkey;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zorse;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.level.Level;

public class Zebra
extends AbstractUnchestedZebroid {
    private static final float MIN_DAMAGE = Zebra.generateAttackDamage(value -> 0);
    private static final float MAX_DAMAGE = Zebra.generateAttackDamage(value -> value - 1);
    private ZebraFleeGoal fleeGoal;

    public Zebra(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void addBehaviourGoals() {
        this.fleeGoal = new ZebraFleeGoal(this, 1.8);
        this.goalSelector.addGoal(2, (Goal)this.fleeGoal);
        this.goalSelector.addGoal(6, new ZebroidFollowParentGoal<Zebra>(this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new HerdLandWanderGoal((PathfinderMob)this, 0.7, 1.2, 16));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractHorse.createBaseHorseAttributes().add(Attributes.ATTACK_DAMAGE).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.FOLLOW_RANGE, 8.0);
    }

    protected void randomizeAttributes(RandomSource random) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)Zebra.generateMaxHealth(arg_0 -> ((RandomSource)random).nextInt(arg_0)));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(Zebra.generateSpeed(() -> ((RandomSource)random).nextDouble()));
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(Zebra.generateJumpStrength(() -> ((RandomSource)random).nextDouble()));
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)Zebra.generateAttackDamage(arg_0 -> ((RandomSource)random).nextInt(arg_0)));
    }

    private static float generateAttackDamage(IntUnaryOperator random) {
        return 1.0f + (float)random.applyAsInt(2) + (float)random.applyAsInt(2) + (float)random.applyAsInt(2);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_AMBIENT.get();
    }

    protected SoundEvent getAngrySound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_ANGRY.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_DEATH.get();
    }

    protected SoundEvent getEatingSound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_EAT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        if (!this.isKicking()) {
            super.getHurtSound(source);
        }
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_HURT.get();
    }

    public void setLastHurtByMob(@Nullable LivingEntity attacker) {
        if (attacker != null && this.level() instanceof ServerLevel) {
            int fleetime = this.getRandom().nextInt(40) + 100;
            float fleedirection = this.getRandom().nextFloat() * 360.0f;
            List<Zebra> zebras = this.level().getEntitiesOfClass(Zebra.class, this.getBoundingBox().inflate(10.0, 4.0, 10.0), zebra -> zebra != this && !zebra.isFleeing() && !zebra.isTamed() && zebra.getTarget() == null).stream().sorted(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)this))).limit(3L).toList();
            for (Zebra zebra2 : zebras) {
                zebra2.getFleeGoal().trigger(fleetime, fleedirection);
            }
            if (this.isBaby()) {
                this.fleeGoal.trigger(fleetime, fleedirection);
            }
        }
        super.setLastHurtByMob(attacker);
    }

    public ZebraFleeGoal getFleeGoal() {
        return this.fleeGoal;
    }

    @Override
    public boolean isFleeing() {
        return this.fleeGoal.running();
    }

    public boolean canMate(Animal otherParent) {
        if (otherParent == this) {
            return false;
        }
        if (!(otherParent instanceof Zebra || otherParent instanceof Horse || otherParent instanceof Donkey)) {
            return false;
        }
        return this.canParent() && ((AbstractHorse)otherParent).canParent();
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        if (otherParent instanceof Horse) {
            Horse horse = (Horse)otherParent;
            Zorse zorse = (Zorse)((EntityType)EnvironmentalEntityTypes.ZORSE.get()).create((Level)level);
            if (zorse != null) {
                int i = this.random.nextInt(9);
                Variant variant = i < 8 ? horse.getVariant() : (Variant)Util.getRandom((Object[])Variant.values(), (RandomSource)this.random);
                int j = this.random.nextInt(5);
                Markings markings = j < 2 ? Markings.NONE : (j < 4 ? horse.getMarkings() : (Markings)Util.getRandom((Object[])Markings.values(), (RandomSource)this.random));
                zorse.randomizeStripeOpacity(level.getRandom());
                zorse.setVariantAndMarkings(variant, markings);
                this.setOffspringAttributes(otherParent, zorse);
            }
            return zorse;
        }
        if (otherParent instanceof Donkey) {
            Zonkey zonkey = (Zonkey)((EntityType)EnvironmentalEntityTypes.ZONKEY.get()).create((Level)level);
            if (zonkey != null) {
                zonkey.randomizeStripeOpacity(level.getRandom());
                this.setOffspringAttributes(otherParent, (AbstractHorse)zonkey);
            }
            return zonkey;
        }
        Zebra zebra = (Zebra)((EntityType)EnvironmentalEntityTypes.ZEBRA.get()).create((Level)level);
        if (zebra != null) {
            this.setOffspringAttributes(otherParent, zebra);
        }
        return zebra;
    }

    public void setOffspringAttributes(AgeableMob otherParent, AbstractHorse child) {
        super.setOffspringAttributes(otherParent, child);
        double d0 = otherParent instanceof Horse ? Zebra.createOffspringAttribute((double)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), (double)0.0, (double)Zorse.MIN_DAMAGE, (double)Zorse.MAX_DAMAGE, (RandomSource)this.random) : (otherParent instanceof Donkey ? Zebra.createOffspringAttribute((double)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), (double)0.0, (double)Zonkey.MIN_DAMAGE, (double)Zonkey.MAX_DAMAGE, (RandomSource)this.random) : Zebra.createOffspringAttribute((double)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), (double)0.0, (double)MIN_DAMAGE, (double)MAX_DAMAGE, (RandomSource)this.random));
        child.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(d0);
    }
}

