/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.zebroid;

import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidAttackGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidAvoidEntityGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidHurtByTargetGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidPanicGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidRandomStandGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidRunAroundLikeCrazyGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidTemptGoal;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zebroid;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Zonkey
extends AbstractChestedHorse
implements NeutralMob,
Zebroid {
    public static final float MIN_DAMAGE = Zonkey.generateAttackDamage(value -> 0);
    public static final float MAX_DAMAGE = Zonkey.generateAttackDamage(value -> value - 1);
    private static final EntityDataAccessor<Integer> KICK_TIME = SynchedEntityData.defineId(Zonkey.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STRIPE_OPACITY = SynchedEntityData.defineId(Zonkey.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> ANGRY_AT = SynchedEntityData.defineId(Zonkey.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)16, (int)32);
    private int remainingPersistentAngerTime;
    private float jumpStrength = -1.0f;
    private int kickCounter = 20;
    private float backKickAnim;
    private float backKickAnimO;
    private float frontKickAnim;
    private float frontKickAnimO;

    public Zonkey(EntityType<? extends AbstractChestedHorse> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, new ZebroidAttackGoal<Zonkey>(this, 1.6));
        this.goalSelector.addGoal(2, new ZebroidPanicGoal<Zonkey>(this, 1.8));
        this.goalSelector.addGoal(3, new ZebroidRunAroundLikeCrazyGoal<Zonkey>(this, 1.6));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0, AbstractHorse.class));
        this.goalSelector.addGoal(5, new ZebroidTemptGoal<Zonkey>(this, 1.25, Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT, Items.GOLDEN_APPLE, Items.ENCHANTED_GOLDEN_APPLE})));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, new ZebroidAvoidEntityGoal<Zonkey, Player>(this, Player.class, 8.0f, 1.0, 1.2));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(11, new ZebroidRandomStandGoal<Zonkey>(this));
        this.targetSelector.addGoal(1, new ZebroidHurtByTargetGoal<Zonkey>(this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Zonkey)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(KICK_TIME, (Object)0);
        builder.define(STRIPE_OPACITY, (Object)100);
        builder.define(ANGRY_AT, Optional.empty());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addPersistentAngerSaveData(compound);
        compound.putInt("StripeOpacity", this.getStripeOpacity());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readPersistentAngerSaveData(this.level(), compound);
        this.setStripeOpacity(compound.getInt("StripeOpacity"));
    }

    protected void randomizeAttributes(RandomSource random) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)Zonkey.generateMaxHealth(arg_0 -> ((RandomSource)random).nextInt(arg_0)));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(Zonkey.generateSpeed(() -> ((RandomSource)random).nextDouble()));
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(Zonkey.generateJumpStrength(() -> ((RandomSource)random).nextDouble()));
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)Zonkey.generateAttackDamage(arg_0 -> ((RandomSource)random).nextInt(arg_0)));
    }

    private static float generateAttackDamage(IntUnaryOperator random) {
        return 1.0f + (float)random.applyAsInt(2);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractHorse.createBaseHorseAttributes().add(Attributes.ATTACK_DAMAGE).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.FOLLOW_RANGE, 8.0);
    }

    @Override
    public void setKickTime(int time) {
        this.entityData.set(KICK_TIME, (Object)time);
    }

    @Override
    public int getKickTime() {
        return (Integer)this.entityData.get(KICK_TIME);
    }

    @Override
    public boolean canJumpKick() {
        return this.jumpStrength >= 0.0f;
    }

    @Override
    public void setJumpStrength(float strength) {
        this.jumpStrength = strength;
    }

    @Override
    public float getJumpStrength() {
        return this.jumpStrength;
    }

    @Override
    public boolean isFleeing() {
        return false;
    }

    @Override
    public void setGallopSoundCounter(int count) {
        this.gallopSoundCounter = count;
    }

    @Override
    public int getGallopSoundCounter() {
        return this.gallopSoundCounter;
    }

    @Override
    public boolean canGallop() {
        return this.canGallop;
    }

    @Override
    public void setKickCounter(int count) {
        this.kickCounter = count;
    }

    @Override
    public int getKickCounter() {
        return this.kickCounter;
    }

    @Override
    public void setBackKickAnim(float amount) {
        this.backKickAnim = amount;
    }

    @Override
    public float getBackKickAnim() {
        return this.backKickAnim;
    }

    @Override
    public void setBackKickAnimO(float amount) {
        this.backKickAnimO = amount;
    }

    @Override
    public float getBackKickAnimO() {
        return this.backKickAnimO;
    }

    @Override
    public void setFrontKickAnim(float amount) {
        this.frontKickAnim = amount;
    }

    @Override
    public float getFrontKickAnim() {
        return this.frontKickAnim;
    }

    @Override
    public void setFrontKickAnimO(float amount) {
        this.frontKickAnimO = amount;
    }

    @Override
    public float getFrontKickAnimO() {
        return this.frontKickAnimO;
    }

    public int getStripeOpacity() {
        return (Integer)this.entityData.get(STRIPE_OPACITY);
    }

    public void setStripeOpacity(int time) {
        this.entityData.set(STRIPE_OPACITY, (Object)time);
    }

    public void randomizeStripeOpacity(RandomSource random) {
        this.setStripeOpacity(33 + random.nextInt(68));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean flag;
        boolean bl = flag = !this.isBaby() && this.isTamed() && player.isSecondaryUseActive();
        if (!(this.isVehicle() || flag || player.getItemInHand(hand).isEmpty() || this.isTamed())) {
            if (this.isAngryAt((LivingEntity)player)) {
                return InteractionResult.CONSUME;
            }
            this.makeMad();
            this.setTarget((LivingEntity)player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        super.tick();
        this.handleTick();
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public void travel(Vec3 motion) {
        boolean flag = this.isJumping();
        super.travel(motion);
        this.handleTravel(flag);
    }

    public void setLeashedTo(Entity entity, boolean broadcast) {
        super.setLeashedTo(entity, broadcast);
        this.handleLeashed(entity);
    }

    public boolean canEatGrass() {
        return this.canDoIdleAnimation();
    }

    public boolean canAttack(LivingEntity target) {
        return (!this.isTamed() || !(target instanceof Player)) && super.canAttack(target);
    }

    public void stopBeingAngry() {
        super.stopBeingAngry();
        this.setLastHurtByPlayer(null);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.entityData.set(ANGRY_AT, Optional.ofNullable(target));
    }

    public UUID getPersistentAngerTarget() {
        return ((Optional)this.entityData.get(ANGRY_AT)).orElse(null);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZONKEY_AMBIENT.get();
    }

    protected SoundEvent getAngrySound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZONKEY_ANGRY.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZONKEY_DEATH.get();
    }

    protected SoundEvent getEatingSound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZONKEY_EAT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        if (!this.isKicking()) {
            super.getHurtSound(source);
        }
        return (SoundEvent)EnvironmentalSoundEvents.ZONKEY_HURT.get();
    }

    @Override
    public void playKickingSound() {
        this.playSound(this.getAmbientSound(), this.getSoundVolume(), this.getVoicePitch());
    }

    @Override
    public void playAngrySound() {
        this.playSound(this.getAngrySound(), this.getSoundVolume(), this.getVoicePitch());
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.handleStepSound(pos, state);
    }

    @Override
    public void playZebroidGallopSound(SoundType soundType) {
        this.playGallopSound(soundType);
    }

    public void positionRider(Entity rider, Entity.MoveFunction function) {
        super.positionRider(rider, function);
        this.handlePositionRider(rider, function);
    }

    public void handleEntityEvent(byte id) {
        if (id == 8) {
            this.playFrontKickAnim();
        } else if (id == 9) {
            this.playBackKickAnim();
        } else {
            super.handleEntityEvent(id);
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.randomizeStripeOpacity(level.getRandom());
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        Zonkey zonkey = (Zonkey)((EntityType)EnvironmentalEntityTypes.ZONKEY.get()).create((Level)level);
        if (zonkey != null) {
            zonkey.randomizeStripeOpacity(level.getRandom());
            this.setOffspringAttributes(otherParent, (AbstractHorse)zonkey);
        }
        return zonkey;
    }

    public void setOffspringAttributes(AgeableMob otherParent, AbstractHorse child) {
        super.setOffspringAttributes(otherParent, child);
        this.setOffspringAttribute(otherParent, child, Attributes.ATTACK_DAMAGE, MIN_DAMAGE, MAX_DAMAGE);
    }

    public int getInventoryColumns() {
        return this.hasChest() ? 3 : 0;
    }
}

