/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.zebroid;

import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidPanicGoal;
import com.teamabnormals.environmental.common.entity.animal.zebroid.AbstractUnchestedZebroid;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;

public class Zorse
extends AbstractUnchestedZebroid
implements VariantHolder<Variant> {
    public static final float MIN_DAMAGE = Zorse.generateAttackDamage(value -> 0);
    public static final float MAX_DAMAGE = Zorse.generateAttackDamage(value -> value - 1);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(Zorse.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STRIPE_OPACITY = SynchedEntityData.defineId(Zorse.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Zorse(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(2, new ZebroidPanicGoal<Zorse>(this, 1.8));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractHorse.createBaseHorseAttributes().add(Attributes.ATTACK_DAMAGE).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.FOLLOW_RANGE, 8.0);
    }

    protected void randomizeAttributes(RandomSource random) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)Zorse.generateMaxHealth(arg_0 -> ((RandomSource)random).nextInt(arg_0)));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(Zorse.generateSpeed(() -> ((RandomSource)random).nextDouble()));
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(Zorse.generateJumpStrength(() -> ((RandomSource)random).nextDouble()));
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)Zorse.generateAttackDamage(arg_0 -> ((RandomSource)random).nextInt(arg_0)));
    }

    private static float generateAttackDamage(IntUnaryOperator random) {
        return 1.0f + (float)random.applyAsInt(2);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.define(STRIPE_OPACITY, (Object)100);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getTypeVariant());
        compound.putInt("StripeOpacity", this.getStripeOpacity());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setTypeVariant(compound.getInt("Variant"));
        this.setStripeOpacity(compound.getInt("StripeOpacity"));
    }

    private void setTypeVariant(int p_30737_) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)p_30737_);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public void setVariantAndMarkings(Variant variant, Markings markings) {
        this.setTypeVariant(variant.getId() & 0xFF | markings.getId() << 8 & 0xFF00);
    }

    public Variant getVariant() {
        return Variant.byId((int)(this.getTypeVariant() & 0xFF));
    }

    public void setVariant(Variant variant) {
        this.setTypeVariant(variant.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    public Markings getMarkings() {
        return Markings.byId((int)((this.getTypeVariant() & 0xFF00) >> 8));
    }

    public int getStripeOpacity() {
        return (Integer)this.entityData.get(STRIPE_OPACITY);
    }

    public void setStripeOpacity(int time) {
        this.entityData.set(STRIPE_OPACITY, (Object)time);
    }

    public void randomizeStripeOpacity(RandomSource random) {
        this.setStripeOpacity(33 + random.nextInt(68));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZORSE_AMBIENT.get();
    }

    protected SoundEvent getAngrySound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZORSE_ANGRY.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZORSE_DEATH.get();
    }

    protected SoundEvent getEatingSound() {
        return (SoundEvent)EnvironmentalSoundEvents.ZORSE_EAT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        if (!this.isKicking()) {
            super.getHurtSound(source);
        }
        return (SoundEvent)EnvironmentalSoundEvents.ZORSE_HURT.get();
    }

    protected void playGallopSound(SoundType soundType) {
        super.playGallopSound(soundType);
    }

    public void containerChanged(Container container) {
        ItemStack itemstack = this.getBodyArmorItem();
        super.containerChanged(container);
        ItemStack itemstack1 = this.getBodyArmorItem();
        if (this.tickCount > 20 && this.isBodyArmorItem(itemstack1) && itemstack != itemstack1) {
            this.playSound(SoundEvents.HORSE_ARMOR, 0.5f, 1.0f);
        }
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return true;
    }

    public boolean isBodyArmorItem(ItemStack stack) {
        return stack.is(Items.LEATHER_HORSE_ARMOR);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        RandomSource random = level.getRandom();
        this.setVariantAndMarkings((Variant)Util.getRandom((Object[])Variant.values(), (RandomSource)random), (Markings)Util.getRandom((Object[])Markings.values(), (RandomSource)random));
        this.randomizeStripeOpacity(level.getRandom());
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        Zorse zorse = (Zorse)otherParent;
        Zorse zorse1 = (Zorse)((EntityType)EnvironmentalEntityTypes.ZORSE.get()).create((Level)level);
        if (zorse1 != null) {
            int i = this.random.nextInt(9);
            Variant variant = i < 4 ? this.getVariant() : (i < 8 ? zorse.getVariant() : (Variant)Util.getRandom((Object[])Variant.values(), (RandomSource)this.random));
            int j = this.random.nextInt(5);
            Markings markings = j < 2 ? this.getMarkings() : (j < 4 ? zorse.getMarkings() : (Markings)Util.getRandom((Object[])Markings.values(), (RandomSource)this.random));
            zorse1.randomizeStripeOpacity(level.getRandom());
            zorse1.setVariantAndMarkings(variant, markings);
            this.setOffspringAttributes(otherParent, zorse1);
        }
        return zorse1;
    }

    public void setOffspringAttributes(AgeableMob otherParent, AbstractHorse child) {
        super.setOffspringAttributes(otherParent, child);
        this.setOffspringAttribute(otherParent, child, Attributes.ATTACK_DAMAGE, MIN_DAMAGE, MAX_DAMAGE);
    }
}

