/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.projectile;

import com.teamabnormals.environmental.common.entity.animal.Duck;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ThrownDuckEgg
extends ThrowableItemProjectile {
    public ThrownDuckEgg(EntityType<? extends ThrownDuckEgg> type, Level worldIn) {
        super(type, worldIn);
    }

    public ThrownDuckEgg(Level worldIn, LivingEntity throwerIn) {
        super((EntityType)EnvironmentalEntityTypes.DUCK_EGG.get(), throwerIn, worldIn);
    }

    public ThrownDuckEgg(Level worldIn, double x, double y, double z) {
        super((EntityType)EnvironmentalEntityTypes.DUCK_EGG.get(), x, y, z, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            if (this.random.nextInt(8) == 0) {
                int i = 1;
                if (this.random.nextInt(32) == 0) {
                    i = 4;
                }
                for (int j = 0; j < i; ++j) {
                    Duck chickenentity = (Duck)((EntityType)EnvironmentalEntityTypes.DUCK.get()).create(this.level());
                    chickenentity.setAge(-24000);
                    chickenentity.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    this.level().addFreshEntity((Entity)chickenentity);
                }
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return (Item)EnvironmentalItems.DUCK_EGG.get();
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)EnvironmentalItems.DUCK_EGG.get());
    }
}

