/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.projectile;

import com.teamabnormals.environmental.common.entity.animal.MuddyPig;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ThrownMudBall
extends ThrowableItemProjectile {
    public ThrownMudBall(EntityType<? extends ThrownMudBall> entity, Level world) {
        super(entity, world);
    }

    public ThrownMudBall(Level worldIn, LivingEntity throwerIn) {
        super((EntityType)EnvironmentalEntityTypes.MUD_BALL.get(), throwerIn, worldIn);
    }

    public ThrownMudBall(Level worldIn, double x, double y, double z) {
        super((EntityType)EnvironmentalEntityTypes.MUD_BALL.get(), x, y, z, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).getEntity();
            entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
            if (entity instanceof Pig) {
                Pig pig = (Pig)entity;
                if (MuddyPig.enabled()) {
                    MuddyPig.setMuddy(pig, true);
                    MuddyPig.updateDryingTime(pig, 1200);
                }
            }
        }
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return (Item)EnvironmentalItems.MUD_BALL.get();
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)EnvironmentalItems.MUD_BALL.get());
    }
}

