/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.item;

import com.teamabnormals.environmental.common.block.WallHibiscusBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;

public class HibiscusBlockItem
extends StandingAndWallBlockItem {
    public HibiscusBlockItem(Block block, Block wallBlock, Item.Properties properties) {
        super(block, wallBlock, properties, Direction.DOWN);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        boolean wallStateIsFloor;
        BlockState normalState = this.getBlock().getStateForPlacement(context);
        BlockState wallState = this.wallBlock.getStateForPlacement(context);
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        boolean pressingShift = context.getPlayer() != null && context.getPlayer().isSecondaryUseActive();
        boolean canPlaceNormalState = normalState != null && this.canPlace((LevelReader)level, normalState, blockPos);
        boolean bl = wallStateIsFloor = wallState != null && wallState.getValue(WallHibiscusBlock.FACE) == AttachFace.FLOOR;
        if (!pressingShift && canPlaceNormalState && (context.getClickedFace() == Direction.UP || wallStateIsFloor)) {
            return normalState;
        }
        return wallState != null && this.canPlace((LevelReader)level, wallState, blockPos) ? wallState : null;
    }
}

