/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.levelgen.feature.configurations.BestNoisesSelectorFeatureConfiguration;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class BestNoisesSelectorFeature
extends Feature<BestNoisesSelectorFeatureConfiguration> {
    public BestNoisesSelectorFeature(Codec<BestNoisesSelectorFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BestNoisesSelectorFeatureConfiguration> context) {
        BestNoisesSelectorFeatureConfiguration config = (BestNoisesSelectorFeatureConfiguration)context.config();
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        ChunkGenerator chunkgenerator = context.chunkGenerator();
        BlockPos origin = context.origin();
        NormalNoise[] noises = config.getNoises(level);
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < noises.length; ++i) {
            values.add(Pair.of((Object)i, (Object)noises[i].getValue((double)origin.getX(), (double)origin.getY(), (double)origin.getZ())));
        }
        values.sort(Comparator.comparingDouble(pair -> -((Double)pair.getSecond()).doubleValue()));
        if ((double)config.blending <= 0.0) {
            return ((PlacedFeature)config.features.get((Integer)((Pair)values.get(0)).getFirst()).value()).place(level, chunkgenerator, random, origin);
        }
        double bestvalue = (Double)((Pair)values.get(0)).getSecond();
        double blendthreshold = bestvalue - (double)config.blending;
        DoubleArrayList validvalues = new DoubleArrayList();
        for (int i = 0; i < noises.length; ++i) {
            double d0 = ((Double)((Pair)values.get(i)).getSecond() - blendthreshold) / (double)config.blending;
            if (!(d0 >= 0.0)) continue;
            validvalues.add(d0);
        }
        int validcount = validvalues.size();
        int featureindex = validcount - 1;
        double sum = validvalues.doubleStream().sum();
        double randomvalue = random.nextDouble();
        for (int i = 0; i < validcount; ++i) {
            double d0 = validvalues.getDouble(i) / sum;
            if (randomvalue < d0) {
                featureindex = i;
                break;
            }
            randomvalue -= d0;
        }
        return ((PlacedFeature)config.features.get((Integer)((Pair)values.get(featureindex)).getFirst()).value()).place(level, chunkgenerator, random, origin);
    }
}

