/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CoarseDirtOnStoneFeature
extends Feature<NoneFeatureConfiguration> {
    public CoarseDirtOnStoneFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int j;
        int i;
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos pos = context.origin();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double radius = this.getRadius(random);
        int intradius = Mth.ceil((double)radius);
        double xoffset = random.nextDouble() - 0.5;
        double yoffset = random.nextDouble() - 0.5;
        int diameter = 2 * intradius;
        int[][] heights = new int[diameter + 1][diameter + 1];
        for (i = 0; i <= diameter; ++i) {
            for (j = 0; j <= diameter; ++j) {
                int x = i - intradius + pos.getX();
                int z = j - intradius + pos.getZ();
                heights[i][j] = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, x, z);
            }
        }
        for (i = 0; i <= diameter; ++i) {
            for (j = 0; j <= diameter; ++j) {
                int maxy;
                int a = i - intradius;
                int b = j - intradius;
                int x = a + pos.getX();
                int z = b + pos.getZ();
                int miny = maxy = heights[i][j] - 1;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    int x1 = i + direction.getStepX();
                    int z1 = j + direction.getStepZ();
                    if (x1 < 0 || x1 > diameter || z1 < 0 || z1 > diameter) continue;
                    miny = Math.min(miny, heights[x1][z1]);
                }
                for (int y = maxy; y >= miny; --y) {
                    double d = Math.pow((double)a - xoffset, 2.0) + Math.pow(y - pos.getY() + 1, 2.0) + Math.pow((double)b - yoffset, 2.0);
                    if (!(d <= radius * radius)) continue;
                    mutable.set(x, y, z);
                    BlockState state = level.getBlockState((BlockPos)mutable);
                    if (!state.is(BlockTags.BASE_STONE_OVERWORLD)) continue;
                    level.setBlock((BlockPos)mutable, Blocks.COARSE_DIRT.defaultBlockState(), 2);
                }
            }
        }
        return true;
    }

    protected double getRadius(RandomSource random) {
        return Math.pow(random.nextDouble(), 2.0) + 1.5;
    }
}

