/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class FallenPineTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final List<Direction> XY_PLANE = List.of(Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST);
    private static final List<Direction> YZ_PLANE = List.of(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH);
    private HashMap<BlockPos, Direction.Axis> logPositions;
    private Set<BlockPos> leafPositions;

    public FallenPineTreeFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int length = this.getLength(random);
        int xOffset = direction.getAxis() == Direction.Axis.X ? length / 2 : 0;
        int zOffset = direction.getAxis() == Direction.Axis.Z ? length / 2 : 0;
        block0: for (int i = 0; i < 8; ++i) {
            BlockPos pos = origin.offset(random.nextInt(4) - random.nextInt(4) - xOffset, random.nextInt(2) - random.nextInt(2), random.nextInt(4) - random.nextInt(4) - zOffset);
            if (!FallenPineTreeFeature.canGenerateAt(level, pos, direction, length)) continue;
            this.logPositions = Maps.newHashMap();
            this.leafPositions = Sets.newHashSet();
            this.doPlace(level, random, pos, length, direction);
            ChunkPos chunkPos = level.getChunk(origin).getPos();
            for (BlockPos leafPos : this.leafPositions) {
                if (this.checkChunkDistance(level, chunkPos, leafPos)) continue;
                continue block0;
            }
            for (BlockPos logPos : this.logPositions.keySet()) {
                if (this.checkChunkDistance(level, chunkPos, logPos)) continue;
                continue block0;
            }
            for (BlockPos leafPos : this.leafPositions) {
                level.setBlock(leafPos, ((Block)EnvironmentalBlocks.PINE_LEAVES.get()).defaultBlockState(), 19);
            }
            for (BlockPos logPos : this.logPositions.keySet()) {
                level.setBlock(logPos, (BlockState)((Block)EnvironmentalBlocks.PINE_LOG.get()).defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)this.logPositions.get(logPos)), 19);
                if (!level.getBlockState(logPos.below()).is(Blocks.GRASS_BLOCK)) continue;
                level.setBlock(logPos.below(), Blocks.DIRT.defaultBlockState(), 2);
            }
            BoundingBox.encapsulatingPositions((Iterable)Iterables.concat(this.logPositions.keySet(), this.leafPositions)).ifPresent(boundingBox -> {
                DiscreteVoxelShape shape = TreeFeature.updateLeaves((LevelAccessor)level, (BoundingBox)boundingBox, this.logPositions.keySet(), Set.of(), Set.of());
                StructureTemplate.updateShapeAtEdge((LevelAccessor)level, (int)3, (DiscreteVoxelShape)shape, (int)boundingBox.minX(), (int)boundingBox.minY(), (int)boundingBox.minZ());
            });
            return true;
        }
        return false;
    }

    private boolean checkChunkDistance(WorldGenLevel level, ChunkPos chunkPos, BlockPos pos) {
        return Math.abs(chunkPos.x - level.getChunk((BlockPos)pos).getPos().x) <= 1 && Math.abs(chunkPos.z - level.getChunk((BlockPos)pos).getPos().z) <= 1;
    }

    private void doPlace(WorldGenLevel level, RandomSource random, BlockPos origin, int length, Direction direction) {
        int l;
        float f;
        List<Direction> plane = direction.getAxis() == Direction.Axis.X ? YZ_PLANE : XY_PLANE;
        for (int j = 0; j < length; ++j) {
            this.logPositions.put(origin.relative(direction, j), direction.getAxis());
        }
        boolean topleaves = random.nextBoolean();
        if (topleaves) {
            this.createTopLeaves(level, origin.relative(direction, length), direction);
        }
        if (random.nextInt(3) == 0) {
            this.createRootDirt(level, random, origin.relative(direction.getOpposite()), direction);
        }
        int topbranches = (f = random.nextFloat()) > 0.6f ? 3 : (f > 0.25f ? 2 : (f > 0.05f ? 1 : 0));
        ArrayList branchdirections = Lists.newArrayList();
        plane.forEach(branchdirections::add);
        int n = l = topleaves ? length - 4 : length - 2;
        while (l > 0) {
            BlockPos blockpos = origin.relative(direction, l);
            if (topbranches > 0 || random.nextInt(l > 4 ? 2 : 4) == 0) {
                Direction branchdirection = topbranches > 0 ? (Direction)branchdirections.remove(random.nextInt(branchdirections.size())) : plane.get(random.nextInt(4));
                BlockPos branchpos = blockpos.relative(branchdirection);
                if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)branchpos)) {
                    this.logPositions.put(branchpos, branchdirection.getAxis());
                }
                if (topbranches > 0) {
                    --topbranches;
                }
            }
            if (topbranches == 0) {
                l -= 2 + random.nextInt(2);
                continue;
            }
            if (topbranches == 1 && random.nextInt(3) == 0) {
                l -= 2;
                continue;
            }
            --l;
        }
    }

    private void createTopLeaves(WorldGenLevel level, BlockPos pos, Direction direction) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = 0; y <= 3; ++y) {
            int r = y < 3 ? y : 1;
            block1: for (int x = -r; x <= r; ++x) {
                for (int z = r; z >= -r; --z) {
                    if (z >= 2 || Math.abs(x) + Math.abs(z) > r) continue;
                    mutable.setWithOffset((Vec3i)pos, FallenPineTreeFeature.rotateToDirection(x, 1 - y, z, direction));
                    if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)mutable)) continue block1;
                    this.leafPositions.add(mutable.immutable());
                }
            }
        }
    }

    private void createRootDirt(WorldGenLevel level, RandomSource random, BlockPos pos, Direction direction) {
        if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            return;
        }
        Direction.Axis axis = direction.getAxis();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        block0: for (int h = 1; h >= -1; --h) {
            for (int y = 1; y >= -1; --y) {
                if (h != 0 && y != 0 && random.nextInt(3) != 0) continue;
                if (axis == Direction.Axis.X) {
                    mutable.setWithOffset((Vec3i)pos, 0, y, h);
                    continue block0;
                }
                mutable.setWithOffset((Vec3i)pos, h, y, 0);
                continue block0;
            }
        }
    }

    private static Vec3i rotateToDirection(int x, int y, int z, Direction direction) {
        return new Vec3i(direction.getStepZ() * x + direction.getStepX() * y, z, direction.getStepX() * x + direction.getStepZ() * y);
    }

    private static boolean canGenerateAt(WorldGenLevel level, BlockPos pos, Direction direction, int length) {
        if (!FallenPineTreeFeature.isDirt((BlockState)level.getBlockState(pos.relative(direction.getOpposite()).below()))) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = pos.mutable();
        int supportblocks = 0;
        for (int i = 0; i < length; ++i) {
            if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)mutable)) {
                BlockPos belowpos = mutable.below();
                BlockState belowstate = level.getBlockState(belowpos);
                if (belowstate.isFaceSturdy((BlockGetter)level, belowpos, Direction.UP)) {
                    ++supportblocks;
                }
            } else {
                return false;
            }
            mutable.move(direction);
        }
        return (float)supportblocks >= (float)length * 0.7f;
    }

    protected int getLength(RandomSource random) {
        return 9 + random.nextInt(5);
    }
}

