/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class LargeBluebellPatchFeature
extends Feature<NoneFeatureConfiguration> {
    private static final NormalNoise NOISE = NormalNoise.create((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(2345L)), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(0, 1.0, new double[0]));

    public LargeBluebellPatchFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        int flowers = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = -16; x <= 16; ++x) {
            for (int z = -16; z <= 16; ++z) {
                mutable.set(x + origin.getX(), level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, x + origin.getX(), z + origin.getZ()), z + origin.getZ());
                double d0 = LargeBluebellPatchFeature.getNoiseAtPos(origin, (BlockPos)mutable);
                if (random.nextInt(10) <= 0 || !(mutable.distSqr((Vec3i)origin) < 324.0) || !(d0 > 0.5) && (!(d0 > 0.05) || random.nextInt(4) != 0)) continue;
                BlockState blockstate = ((Block)EnvironmentalBlocks.BLUEBELL.get()).defaultBlockState();
                if (random.nextInt(6) == 0) {
                    BlockState blockState = blockstate = random.nextInt(3) > 0 ? Blocks.SHORT_GRASS.defaultBlockState() : Blocks.FERN.defaultBlockState();
                }
                if (!level.isEmptyBlock((BlockPos)mutable) || !blockstate.canSurvive((LevelReader)level, (BlockPos)mutable)) continue;
                level.setBlock((BlockPos)mutable, blockstate, 2);
                ++flowers;
            }
        }
        return flowers > 0;
    }

    private static double getNoiseAtPos(BlockPos origin, BlockPos pos) {
        double d0 = NOISE.getValue((double)pos.getX() * 0.05, 0.0, (double)pos.getZ() * 0.05);
        return 1.0 - pos.distSqr((Vec3i)origin) / 256.0 + d0 * 1.35;
    }
}

